#include "m.h"

void process(char *pattern, char *dest)
{
    glob_t
        globvec;

    if (glob(pattern, 0, 0, &globvec))      // glob failed for some reason
        return;                             // then assume we're done.

    int
        destlen = strlen(dest) + 1;         // add 1 for trailing /

                                            // walk all entries
    for (int index = 0; index < globvec.gl_pathc; index++)
    {
        char
            *entry =  globvec.gl_pathv[index];
        struct stat
            buf;

        if (stat(entry, &buf))              // no stat info, continue
        {
            delete entry;
            continue;
        }

        char
            *destination = new char[destlen + strlen(entry) + 1];
        sprintf(destination, "%s/%s", dest, entry);

        if (S_ISDIR(buf.st_mode))           // entry is a directory
            directory(entry, destination);
        else if (S_ISREG(buf.st_mode))      // entry is a regular file
            file(destination, entry, buf.st_mode);

        delete entry;
        delete destination;
    }

    free(globvec.gl_pathv);
}
