#include "m.h"


void makehome(USER_ *up)
{
    struct stat
        buf;
    char
        *dest = up->p_dir;

    if (!stat(dest, &buf))          // file exists
    {
        alert("Directory exists. Make skipped for user", up->p_name);
        statebutton(st_files_ok);
        return;                     // then do nothing
    }

    if (chdir(app_defaults.skeleton))       // can't change to /etc/skel
    {
        int
            mask;

        mask = umask (0);
        umask (mask);

        if (makedir(dest, ~mask))           // then make a default dir
            alert("Can't make home-directory for user", up->p_name);
        return;
    }

    cp_recursively(dest);               // copy information recursively
    statebutton(st_files_ok);
    up->state = st_files_ok;
}


    
