#include "cb.h"

void u_display(USER_ const *up)             // display info about (known) user
{
    fl_set_input(name,      up->p_name);
    fl_set_input(dir,       up->p_dir);
    fl_set_input(shell,     up->p_shell);
    fl_set_input(uid,       itoa(up->p_uid));
    fl_set_input(gid,       lookup_group(up->p_gid));
    fl_set_input(fullname,  up->c_name);
    fl_set_input(office1,   up->c_office1);
    fl_set_input(office2,   up->c_office2);
    fl_set_input(address,   up->c_address);

    pwchange = up->sp_lstchg;

    if (!app_defaults.force_sh)
    {
        min     = unlimited(up->sp_min);
        max     = unlimited(up->sp_max);
        if (min > max)
            max = min;
        warn    = -up->sp_warn;
        if (warn < -max)
            warn = -max;
        inact   = unlimited(up->sp_inact);
        expire  = up->sp_expire > app_defaults.unlimited + today ?
                app_defaults.unlimited + today
            :
                up->sp_expire;
    }
    else
    {
        warn     = -app_defaults.alert;
        min      = app_defaults.fixed;
        max      = app_defaults.change;
        inact    = app_defaults.entry;
        expire   = today + app_defaults.expiration;
    }

    shadowfields();
}

    
