#include "cb.h"

USER_ *u_defaults(char const *uname)
{
    USER_
        *up;
    char
        buffer[80];

    strcpy(buffer, app_defaults.home);
    strcat(buffer, uname);

    up = new USER_;
    memset(up, 0, sizeof(USER_));

    up->p_uid = -1;
    up->p_gid = lookup_gid(app_defaults.group);

    up->p_name      = strdup(uname);
    up->p_pwd       = strdup(nullstring);
    up->p_dir       = strdup(buffer);
    up->p_shell     = strdup(app_defaults.shell);
    up->c_name      = strdup(nullstring);
    up->c_office1   = strdup(nullstring);
    up->c_office2   = strdup(nullstring);
    up->c_address   = strdup(nullstring);
    up->s_pwd       = strdup(nullstring);

    up->sp_lstchg   = today;
    up->sp_expire   = today + app_defaults.expiration;
    up->sp_warn     = app_defaults.alert;
    up->sp_min      = app_defaults.fixed;
    up->sp_max      = app_defaults.change;
    up->sp_inact    = app_defaults.entry;

    statebutton(access(buffer, F_OK) ? st_make : st_files_ok);

    return (up);
}
