#include "cb.h"

void cb_shadowint(FL_OBJECT *ob, long u_type)
{
    DAY_
        day = get_days(ob);

    if (day.type == d_invalid)
        fl_set_object_focus(f_main, ob);            // repair error below
    else
    {
        switch (u_type)
        {
            case u_min:
                min =                           // days relative to pwchange
                    unlimited
                    (
                        (day.type == d_long) ?
                            day.value + today - pwchange
                        :
                            day.value - pwchange
                    );

                if (min > max)                  // min must be <= max
                    min = max;
            break;

            case u_max:
                max =                           // days relative to pwchange
                    unlimited
                    (
                        (day.type == d_long) ?
                            day.value + today - pwchange
                        :
                            day.value - pwchange
                    );

                if (min > max)                  // max must be >= min
                    max = min;
            break;

            case u_warn:
                warn =
                    (day.type == d_long) ?
                        -day.value              // days relative to max
                    :
                        day.value - (pwchange + max);

                if (warn < -max)                // warning starts at pwchange
                    warn = -max;                // date
                else if (warn > 0)
                    warn = 0;
            break;

            case u_inact:
                inact =
                    (day.type == d_long) ?
                        day.value              // days relative to max
                    :
                        day.value - (pwchange + max);

                                                // inact at most unlimited 
                                                // # days away
                if (inact > max - app_defaults.unlimited)
                    inact = max - app_defaults.unlimited;
                else if (inact < 0)
                    inact = 0;
            break;

            case u_expire:
                expire =
                    day.value > today + app_defaults.unlimited ?
                        today + app_defaults.unlimited
                    :
                        day.value;
        }
    }

     shadowfields();
}




