#include "aux.h"

static char
    none[] = "<none specified>";

void options_check2()
{
    if
    (
        *app_defaults.group                         // app-defaults specified
        &&
        lookup_gid(app_defaults.group) < 0          // failed
    )
    {
        alert("Clearing invalid group option:", app_defaults.group);
        strredef(app_defaults.group, nullstring);
    }

    app_defaults.shell = (char *)realloc(app_defaults.shell,
                                  1 + strlen(app_defaults.shell));
    if (!*app_defaults.shell)
        strredef(app_defaults.shell, fl_get_browser_line(shellbrowser, 1));

    if (app_defaults.options)
    {
        fprintf
        (
            stderr,
            "%s\n"
            "\n"
            "XUser -- active default options:\n"
            "   account expires afer:       %u days\n"
            "   alert before passwd change: %u days\n"
            "   backup extension:           %s\n"
            "   base of home-directories:   %s\n"
            "   default groupname:          %s\n"
            "   default shadow parameters:  %s\n"
            "   default shellname:          %s\n"
            "   entry with expired passwd:  %u days\n"
            "   groups file:                %s\n"
            "   minimum password length:    %u characters\n"
            "   passwd file:                %s\n"
            "   password fixation:          %u days\n"
            "   password change after:      %u days\n"
            "   shadow file:                %s\n"
            "   shells file:                %s\n"
            "   skeleton directory:         %s\n"
            "   unlimited amount of time:   %u days\n"
            , release
            , app_defaults.expiration
            , app_defaults.alert
            , app_defaults.backup
            , app_defaults.home
            , *app_defaults.group ? app_defaults.group : none
            , app_defaults.force_sh ?  "enforced on initial display" :
                                    "not enforced" 
            , app_defaults.shell
            , app_defaults.entry
            , app_defaults.groups
            , app_defaults.length
            , app_defaults.passwd
            , app_defaults.fixed
            , app_defaults.change
            , app_defaults.shadow
            , app_defaults.shells
            , app_defaults.skeleton
            , app_defaults.unlimited
        );
    }
}
