#include "aux.h"

void initialize(int *argc, char **argv)
{
    set_new_handler(handler);               // memory handler installed

    today = time(0) / (24 * 3600);         // #days since 70/01/01

    set_app_defaults();                     // set initial stringbuffers

    fl_initialize(argv[0], "XUser", cmdopt, sizeof_cmdopt, argc, argv);

    fl_get_app_resources(res, sizeof_res);

    options_check1();
    pw_read();                      // read in the password file
    sdw_read();                     // read in the shadow-file
    f_xuser();
    f_shellbrowser();
    f_uidbrowser();
    f_namebrowser();
    f_groupbrowser();
    f_errorbrowser();
    f_password();
    hide_objects();

    options_check2();

    if (*argc > 1)
    {
        fl_set_input(name, argv[1]);
        cb_name(name, 0);
    }

    fl_show_form
    (
        f_main,
        FL_PLACE_CENTER, FL_FULLBORDER, xuser
    );
}
