#include "../xuser.h"

char const
    xuser[]         = "XUser",
    nullstring[]    = "",
    zerostring[]    = "0",
    fivestring[]    = "5",
    sevenstring[]   = "7",
    r[]             = "r",
    w[]             = "w";

USER_
    *up = 0,
    *user = 0;

long
    pwchange,
    inact,
    min,                                    // # of days relative to 
    max,                                    // their base-values
    warn,
    expire,
    today;

unsigned    
    errors,
    hidden_objects = 0,
    nrmlist = 0,                                
    nusers = 0;

FL_FORM
    *f_browsegroup,
    *f_browseerror,
    *f_main,
    *f_browseshell,
    *f_browseuid,
    *f_browsename,
    *f_passwd;

FL_OBJECT
    *cancel_passwd,
    *no_shadow_entry,
    *leave_namebrowser,
    *name_button,
    *name_0_button,
    *nopasswd,
    *hide_group,
    *copyright,
    *pwd1group,
    *pwd2group,
    *pwdinput1,
    *pwdinput2,
    *button_group,
    *leave_groupbrowser,
    *namebrowser,
    *groupbrowser,
    *leave_shellbrowser,
    *shellbrowser,
    *leave_uidbrowser,
    *uidbrowser,
    *errorbrowser,
    *leave_errorbrowser,
    *name,
    *uid,
    *gid,
    *dir,
    *shell,
    *fullname,
    *office1,
    *office2,
    *address,
    *uid_button,
    *gid_button,
    *shell_button,
    *accept_button,
    *save_button,
    *cancel_button,
    *exit_button,
    *make_button,
    *files_ok_button,
    *delete_button,
    *rm_rf_button,
    *spwchg,
    *smin,
    *smax,
    *swarn,
    *sinact,
    *sexpire,
    *ssetpw;
char
    **rmlist = 0,
    *pwd;

APP_DEFAULTS_
    app_defaults;

FL_CMD_OPT
    cmdopt[] =
    {
        {"-shells",     "*shells",      XrmoptionSepArg, 0},
        {"-passwd",     "*passwd",      XrmoptionSepArg, 0},
        {"-shadow",     "*shadow",      XrmoptionSepArg, 0},
        {"-skeleton",   "*skeleton",    XrmoptionSepArg, 0},
        {"-backup",     "*backup",      XrmoptionSepArg, 0},
        {"-length",     "*length",      XrmoptionSepArg, 0},
        {"-fixed",      "*fixed",       XrmoptionSepArg, 0},
        {"-change",     "*change",      XrmoptionSepArg, 0},
        {"-alert",      "*alert",       XrmoptionSepArg, 0},
        {"-entry",      "*entry",       XrmoptionSepArg, 0},
        {"-expiraton",  "*expiration",  XrmoptionSepArg, 0},
        {"-group",      "*group",       XrmoptionSepArg, 0},
        {"-groups",     "*groups",      XrmoptionSepArg, 0},
        {"-shell",      "*shell",       XrmoptionSepArg, 0},
        {"-home",       "*home",        XrmoptionSepArg, 0},
        {"-options",    "*options",     XrmoptionNoArg,  "True"},
        {"-unlimited",  "*unlimited",   XrmoptionSepArg, 0},
        {"-force",      "*force-shadow-defaults",    XrmoptionNoArg,  "True"},
    };

FL_resource
    res[] =
    {
        {"backup",      xuser, FL_STRING, 0, "-",           250},
        {"group",       xuser, FL_STRING, 0, nullstring,    250},
        {"groups",      xuser, FL_STRING, 0, "/etc/group",  250},
        {"home",        xuser, FL_STRING, 0, "/home",       250},
        {"passwd",      xuser, FL_STRING, 0, "/etc/passwd", 250},
        {"shadow",      xuser, FL_STRING, 0, "/etc/shadow", 250},
        {"shell",       xuser, FL_STRING, 0, nullstring,    250},
        {"shells",      xuser, FL_STRING, 0, "/etc/shells", 250},
        {"skeleton",    xuser, FL_STRING, 0, "/etc/skel",   250},

        {"length",      xuser, FL_INT,  &app_defaults.length,    fivestring},
        {"fixed",       xuser, FL_INT,  &app_defaults.fixed,     zerostring},
        {"change",      xuser, FL_INT,  &app_defaults.change,    zerostring},
        {"alert",       xuser, FL_INT,  &app_defaults.alert,     sevenstring},
        {"entry",       xuser, FL_INT,  &app_defaults.entry,     sevenstring},
        {"expiration",  xuser, FL_INT,  &app_defaults.expiration,zerostring},
        {"unlimited",   xuser, FL_INT,  &app_defaults.unlimited, "10000"},
        {"options",     xuser, FL_BOOL, &app_defaults.options,   zerostring},
        {"force-shadow-defaults",
                        xuser, FL_BOOL, &app_defaults.force_sh,  zerostring},
    };

unsigned
    sizeof_cmdopt   = sizeof(cmdopt)    /   sizeof(FL_CMD_OPT),
    sizeof_res      = sizeof(res)       /   sizeof(FL_resource);
