/* File     : stack_func.c
 * Author   : Karyl F. Stein <steinkf@cs.purdue.edu>
 * Purpose  : Functions for use with xnew to manage the stack.  The individual
 *            functions are detailed before the function below.
 *
 * Xnew is Copyright (C)1996 Karyl F. Stein <xenon@xenos.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stack_func.h"  /* Function prototypes */


/* Function: push
 * Input   : A line number to push and a stack to push it onto.
 * Output  : A pointer to the new stack with the passed number on the top.
 */
stack_node push (fpos_t position, int line, stack_node stack) {
  stack_node retval;

  if ((retval = (stack_node) malloc(sizeof(struct stack_node_t))) == NULL) {
    fprintf(stderr, "Out Of Memory\n");
    exit(1);
  }
  retval->position = position;
  retval->line = line;
  retval->next = stack;
  return(retval);
}


/* Function: pop
 * Input   : A stack to pop the top element from.
 * Output  : A pointer to the new stack with the top element removed.
 */
stack_node pop (stack_node stack) {
  stack_node retval;

  if (stack == NULL)
    return(NULL);
  retval = stack->next;
  free(stack);
  return(retval);
}
