/* File   : verify_info.c
 * Author : Karyl F. Stein <xenon@xenos.net>
 * Purpose: Verify information that the user entered.
 * Input  : Name of file to communicate with xnew, login name of user, full
 *          name of user, shell, editor, terminal type, backspace key,
 *          interrupt key, and kill key.
 *
 * This code is Copyright (C)1996 Karyl F. Stein <xenon@xenos.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * TODO: Check to make sure arguments are given.
 *       Allow dynamic passing of arguments.
 */

#include <stdio.h>
#include "get_input.h"
#include "mod_func.h"


main(int argc, char *argv[]) {
  char *retval = NULL;
  FILE *pipe_fp;

  /* Make sure we got enough arguments */
  if (argc <= 6)
    exit(1);

  /* Open the pipe for writing */
  if ((pipe_fp = fopen(argv[1], "w")) == NULL) {
    fprintf(stderr, "Error: Child %s unable to access pipe\n", argv[0]);
    exit(1);
  }

  while (1) {

    /* Do this better */
    system("clear");

    center("Verify Information", 80);
    printf("\n(L)ogin    : %s\n", argv[2]);
    printf("(F)ull Name: %s\n", argv[3]);
    printf("(P)assword : [NOT SHOWN]\n\n");
    printf("(S)hell    : %s\n", argv[4]);
    printf("(E)ditor   : %s\n", argv[5]);

    printf("(T)erminal : %s\n\n", argv[6]);
    printf("(B)ackspace: ");
    print_char(*argv[7], FULL);
    printf("\n(I)nterrupt: ");
    print_char(*argv[8], FULL);
    printf("\n(K)ill Key : ");
    print_char(*argv[9], FULL);

    printf("\n\nEnter letter of the field to change, or just press ENTER if done: ");

    retval = get_input(NULL, 1, 80, LETTER | LOWERCASE);
    putc('\n', stdout);
    if (retval != NULL) {
      if ((*retval == 'l') || (*retval == 'f') || (*retval == 'p') ||
	  (*retval == 's') || (*retval == 'e') || (*retval == 't') ||
          (*retval == 'b') || (*retval == 'i') || (*retval == 'k')) {
	fprintf(pipe_fp, "%s", retval);
	free(retval);
	break;
      } else if (*retval == '\0') {
	fprintf(pipe_fp, "NULL");
	free(retval);
	break;
      }
      free(retval);
    }
  }

  /* Close the pipe */
  fclose(pipe_fp);
}
