#ifndef _MOD_FUNC_H
#define _MOD_FUNC_H

#include <stdio.h>

/* The size of the input buffer.  Usually, this can be left alone, but it    */
/* can be tweaked for your I/O.  This is not a maximum value for the input;  */
/* it just defines how large a chunk is requested for reading.  Also, input  */
/* buffers are allocated in chunks of INBUF size.  To save (a small amount   */
/* of) memory, this value can be lowered.  If input is continuously larger   */
/* than INBUF, then time will be spent reallocating memory to hold all the   */
/* input.  If INBUF is set below 2, a default value will be used.            */
#define INBUF 512

/* Defines used by print_char() */
#define CTRL_ONLY 0x01
#define TEXT_ONLY 0x02
#define FULL      0x04

/* Defines used by skip() */
#define COMMENTS 0x01
#define SPACE    0x02
#define TO_EOL   0x04
#define WHITE    0x08


/* Function prototypes */
char *get_word(FILE *);

int printtxt (char *);

void center(char *, int);
void print_char(char, int);
void skip(FILE *, int);
void skip_line(FILE *, int);

#endif  /* _MOD_FUNC_H */
