#ifndef _GET_SHELL_H
#define _GET_SHELL_H

/* File   : get_shell.h                                                     */
/* Purpose: Definitions for get_shell.c.                                    */

/* File containing a list of valid shells.  The format of this file is:     */
/*                                                                          */
/* <shell> </path/to/shell>                                                 */
/*                                                                          */
/* Each definition must be on a seperate line and contain two entries       */
/* seperated by spaces or tabs.  Anything else on the line is considered    */
/* to be a comment and ignored.  Comments can also appear as the first      */
/* entry on a line by prefacing them with a # character.                    */
/*                                                                          */
/* The <shell> argument is the name of the shell as displayed to the user.  */
/* The </path/to/shell> argument is the name of the shell including the     */
/* path leading to it.                                                      */
/*                                                                          */
/* Depending on your system, valid shells may also have to be located in    */
/* /etc/shells or some file like that.                                      */
/*                                                                          */
/* If this is not defined, then no checking will be done to see if the user */
/* entered a valid shell.  Plus, the user will have to enter the full name, */
/* (including path), to the shell.                                          */
/*                                                                          */
/* If you do not want to enable this feature, delete the preceeding /*      */
/* before the line that reads "/* undef SHELL_LIST"                         */
#define SHELL_LIST "/usr/noton/xnew/templates/shells"
/* #undef SHELL_LIST /* */

/* Default shell to use.  If this is undefined, no default shell is given.  */
/* If SHELL_LIST is defined, this should be an entry in that file and not   */
/* contain a leading path.  If you do not want to enable this feature,      */
/* delete the preceeding /* before the line that reads "/* undef DEF_SHELL" */
#define DEF_SHELL "menu"
/* #undef DEF_SHELL /* */

/* File shown when help is requested. If you do not want to enable this     */
/* feature, delete the preceeding /* before the line that reads             */
/* "/* #undef SHELL_HELP"                                                   */
#define SHELL_HELP "/usr/noton/xnew/text/shell_help.txt"
/* #undef SHELL_HELP /* */

/* File shown when an invalid shell is selected.  If you do not want to     */
/* enable this feature, delete the preceeding /* before the line that reads */
/* "/* #undef INVALID_SHELL"                                                */
#define INVALID_SHELL "/usr/noton/xnew/text/shell_invalid.txt"
/* #indef INVALID_SHELL /* */

#endif  /* _GET_SHELL_H */
