/* File     : get_name.c
 * Author   : Karyl F. Stein <xenon@xenos.net>
 * Purpose  : Module for use with the xnew program to input a full name.
 * Usage    : get_name [strict]
 *
 *            If the strict argument is given, two words seperated by a
 *            space must be entered as a name.
 *
 * Notes    : Be sure to edit get_name.h to change the path of the text
 *            files used by this module.
 *
 * This file is Copyright (C)1996 Karyl F. Stein <xenon@xenos.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "get_name.h"
#include "get_input.h"
#include "mod_func.h"
#include <stdio.h>

/* Set defaults if not defined previously or not valid */
#ifndef MAXNAMELEN
# define MAXNAMELEN 30
#endif

/* Local function prototypes */
int testname(char *);


main (int argc, char *argv[]) {
  char c;
  char *name;
  FILE *pipe_fp;
  int flag = 0;

  /* Make sure we got at least one argument (the pipe to write to) */
  if (argc <= 1)
    exit(1);

  /* Open the pipe for writing */
  if ((pipe_fp = fopen(argv[1], "w")) == NULL) {
    fprintf(stderr, "Error: Child %s unable to access pipe\n", argv[0]);
    exit(1);
  }

  /* See if any flags were passed */
  if ((argc > 2) && (strcmp(argv[2], "strict") == 0))
    flag = 1;

  /* Loop until we get a valid name */
  while (1) {

#ifndef NAME_HELP
    name = get_input("Enter your full name: ", MAXNAMELEN, 80, TEXT);
#else
    name = get_input("Enter your full name: ", MAXNAMELEN, 80, TEXT | HELP);
#endif

    putc('\n', stdout);

#ifdef NAME_HELP
    /* Print a help message */
    if (name == NULL) {
      printtxt(NAME_HELP);
      continue;
    }
#endif

    /* Print an error message if needed */
    if (((*name == '\0')) && (flag)) {
      puts("\nYou must enter a name.\n\n");
      free(name);
    }

    else if ((flag) && (testname(name))) {
#ifdef INVALID_NAME
      printtxt(INVALID_NAME);
#endif
      free(name);
    }

    else break;
  }

  /* Print the name to the pipe */
  if (*name == '\0')
    fprintf(pipe_fp, "%c", *name);
  else fprintf(pipe_fp, "%s", name);

  fclose(pipe_fp);
}


/* Function: testname
 * Input   : A name to test
 * Output  : 0 if the name consists of a first and last name seperated by
 *           a space, otherwise 1.  The first and last names only need to
 *           be 1 character long.
 *
 * Note    : Names may contain characters other than letters.
 */
int testname (char *name) {
  int flag;

  for (flag = 0; *name != '\0'; ++name) {
    if (flag) {
      if (*name != ' ')
	return(0);
    } else if (*name == ' ')
      flag = 1;
  }

  return(1);
}
