#ifndef _GET_INTERRUPT_H
#define _GET_INTERRUPT_H

/* File   : get_interrupt.h                                               */
/* Purpose: Definitions for get_interrupt.c.                              */

/* Process by which a control key is made.  Do not change unless you know */
/* you are doing.  (This should be read from a system header file.)       */
#define CTRL(ch) ((ch) & 0x1f)

/* Default interrupt key.  If you do not want this feature, delete the */
/* preceeding /* from the line that reads "/* #undef DEF_INTERRUPT"    */
#define DEF_INTERRUPT CTRL('c')
/* #undef DEF_INTERRUPT /* */

/* File that is printed when help is requested.  If you do not want this */
/* feature, remove the preceeding /* from the line that reads            */
/* "/* #undef INTERRUPT_HELP"                                            */
#define INTERRUPT_HELP "/usr/noton/xnew/text/interrupt_help.txt"
/* #undef INTERRUPT_HELP /* */

#endif  /* _GET_INTERRUPT_H */
