#ifndef _GET_EDITOR_H
#define _GET_EDITOR_H

/* File   : get_editor.h                                                    */
/* Purpose: Definitions for get_editor.c.                                   */

/* File containing a list of valid editors.  The format of this file is:    */
/*                                                                          */
/* <editor> </path/to/editor>                                               */
/*                                                                          */
/* Each definition must be on a seperate line and contain two entries       */
/* seperated by spaces or tabs.  Anything else on the line is considered    */
/* to be a comment and ignored.  Comments can also appear as the first      */
/* entry on a line by prefacing them with a # character.                    */
/*                                                                          */
/* The <editor> argument is the name of the editor as displayed to the      */
/* user.  The </path/to/editor> argument is the name of the editor          */
/* including the path leading to it.                                        */
/*                                                                          */
/* If this is not defined, then no checking will be done to see if the user */
/* entered a valid shell.  Plus, the user will have to enter the full name, */
/* (including path), to the editor if it is not in their search path.       */
/*                                                                          */
/* If you do not want to enable this feature, delete the preceeding /*      */
/* before the line that reads "/* undef EDITOR_LIST"                        */
#define EDITOR_LIST "/usr/noton/xnew/templates/editors"
/* #undef EDITOR_LIST /* */

/* Default editor to use.  If EDITOR_LIST is defined, this must be a valid  */
/* entry.  If EDITOR_LIST is not defined, this should be in the default     */
/* path or contain a path.  If you do not want to enable this feature,      */
/* delete the preceeding /* from the line that reads "/* #undef DEF_EDITOR" */
#define DEF_EDITOR "pico"
/* #undef DEF_EDITOR /* */

/* Help file to print.  If you do not want to enable this feature, delete */
/* the preceeding /* from the line that reads "/* #undef EDITOR_HELP"     */
#define EDITOR_HELP "/usr/noton/xnew/text/editor_help.txt"
/* #undef EDITOR_HELP /* */

/* File to print if an invalid editor is chosen.  If you do not want to   */
/* enable this feature, delete the preceeding /* from the line that reads */
/* "/* #undef EDITOR_INVALID"                                             */
#define EDITOR_INVALID "/usr/noton/xnew/text/editor_invalid.txt"
/* #undef EDITOR_INVALID /* */

/* The maximum length an editor name may be.                              */
#define MAX_EDITOR_LEN 50

#endif  /* _GET_EDITOR_H */
