/* File   : config_func.c
 * Author : Karyl F. Stein <xenon@xenos.net>
 * Purpose: Read configuration files into memory for fast lookups.
 *
 * This file is Copyright (C)1997 Karyl F. Stein <xenon@xenos.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "config_func.h"


config_node new_config_node (void) {
  config_node retval;

  if ((retval = (config_node) malloc(sizeof(struct config_node_t))) == NULL) {
    fprintf(stderr, "Out Of Memory\n");
    exit(1);
  }

  retval->name = NULL;
  retval->value = NULL;
  retval->next = NULL;

  return(retval);
}


config_node read_config (char *filename) {
  char c;
  FILE *ifp;
  long pos;

  if ((ifp = fopen(filename, "r")) == NULL)
    return(NULL);

  fseek(ifp, 10, SEEK_SET);
  fseek(ifp, -5, SEEK_CUR);
  printf("%c\n", getc(ifp));
}


main() {
  read_config("config_func.c");
}
