/* File     : list_func.c
 * Author   : Karyl F. Stein <xenon@xenos.net>
 * Purpose  : Functions for use with the xnew program for managing the lists.
 *            The individual functions are detailed before the function below.
 *
 * Xnew is Copyright (C)1996 Karyl F. Stein <xenon@xenos.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "xnew.h"       /* Global variables    */
#include "list_func.h"  /* Function prototypes */
#include <stdio.h>      /* NULL                */


/* Function: get_result
 * Input   : The command to search for in the result list
 * Return  : A pointer to the result string of the command or NULL
 */
char *get_result (char *command) {
  data_node ptr = search_list(command);

  if (ptr != NULL)
    return(ptr->result);
  return(NULL);
}


/* Function: search_list
 * Input   : The command to search for in the list
 * Return  : A pointer to the list node or NULL if not found
 */
data_node search_list (char *command) {
  extern data_node result_list;
  data_node ptr = result_list;

  while (ptr != NULL) {
    if (strcmp(ptr->command, command) == 0)
      return(ptr);
    ptr = ptr->next;
  }

  return(NULL);
}
