#ifndef _CONFIG_H
#define _CONFIG_H

/* File   : config.h                                                         */
/* Purpose: User configurable options for the xnew program.                  */


/* The default input script to use.  This file is necessary to tell xnew     */
/* what to do.  See the README for instructions for writing this file.       */
#define INPUT_FILE "/usr/noton/xnew/xnew.config"

/* This is where the modules reside.                                         */
#define DATA_DIR "/usr/noton/xnew/modules"

/* This is where all the temporary files will be placed.  This directory     */
/* must be writable by the user the xnew program is running as during        */
/* the execution of modules.                                                 */
#define TMP_DIR "/tmp"

/* The size of the input buffer.  Usually, this can be left alone, but it    */
/* can be tweaked for your I/O.  This is not a maximum value for the input;  */
/* it just defines how large a chunk is requested for reading.  Also, input  */
/* buffers are allocated in chunks of INBUF size.  To save (a small amount   */
/* of) memory, this value can be lowered.  If input is continuously larger   */
/* than INBUF, then time will be spent reallocating memory to hold all the   */
/* input.  If INBUF is set below 2, a default value will be used.            */
#define INBUF 512

#endif  /* _CONFIG_H */
