/*
**	chpd v1.0 (C)opyright 1996 Jawed Karim <kari0022@gold.tc.umn.edu>
**
**	This  file may be freely  distributed  as long as this messsage
**	remains intact.  You may  make modifications to this file under
**	the condition that the modified chpd is not redistributed. Tell
**	me about any useful changes you make.
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/stat.h>

#define MAX_LINE 256

void error_exit(char *);

void main()
{
	struct stat oldinfo;
	struct stat newinfo;

	FILE *oldpasswd;
	FILE *newpasswd;
	FILE *output;

	char oldbuffer[MAX_LINE];
	char newbuffer[MAX_LINE];
	char username[MAX_LINE];
	char tmp[MAX_LINE];

	long oldposition;

        struct passwd *pw=NULL;
        pw = getpwuid (geteuid());
        sprintf(username, "%s", pw->pw_name);

	if (!strcmp ("root", username))
		error_exit("chpd should not be run as root");

	if (system("cd ~")) {
		error_exit("unable to cd ~");
	}

	/*
	 * does ~/passwd.old already exist? If not, copy it to $HOME
	 */

	if (access("passwd.old", R_OK) == 0) {
		puts("*** ~/passwd.old exists");
	}

	else {
		if (system("cp /etc/passwd ~/passwd.old")) {
			error_exit("unable to access /etc/passwd");
		}

		printf("\nThe file /etc/passwd has been copied to ~/passwd.old."
		"\nEach chpd is active, this file will be compared to the"
		"\noriginal and you will be notified of any changes.");
		puts("");
	 
		exit(0);
	}

	stat("/etc/passwd", &newinfo);
	stat("passwd.old", &oldinfo);

	if (newinfo.st_size == oldinfo.st_size) {
		puts("*** The passwd file has not changed since it was"
			" last checked");
		exit(0);
	}

	oldpasswd = fopen("passwd.old", "r");
	newpasswd = fopen("/etc/passwd", "r");

	output = fopen("passwd.changes", "w");

	/*
	 * compare ~/passwd with /etc/passwd, line for line
	 */

	while ( fgets (newbuffer, 256, newpasswd) != NULL ) {
		oldposition = ftell(oldpasswd);
		fgets (oldbuffer, 256, oldpasswd);
		if (strcmp (newbuffer, oldbuffer) != 0) {
			fprintf(output, newbuffer);
			fseek(oldpasswd, oldposition, 0);
		}
	}

	puts("*** /etc/passwd has been modified");
	puts("*** Updating passwd.old");
	
		if (system("cp /etc/passwd ~/passwd.old")) {
			error_exit("unable to access /etc/passwd");
		}

		sprintf(tmp,
	"mail -s \"PASSWD CHANGED\" %s < passwd.changes > /dev/null", username);

		if (system(tmp)) {
			error_exit("unable to mail user");
		}
		else {
			puts("*** Sent empty email notification");
		}
}

void error_exit(char *message)
{
	fprintf(stderr, "\a\n--> %s\n", message);
	exit(1);
}
