/****
** 7/26/96
** shadow-adduser 1.6 (2.0?):
** Wow, a basic re-write of the data entry portion of the
** program.  Added command-line options, better password checking,
** and the ability to change params once they're entered.
** 
** Also added the public-home-dir feature for uucp/ftp/etc users.  
** The rewrite started out as a quest to add just this and
** turned out this way.  Oh well =)
**
** bunches of other little stuff, but I didn't touch the actual 
** code that manipulates files.
** 
** Ben Osheroff
** mtr@ratbert.bagel.org
**
** 5/26/96
** shadow-adduser 1.5:
**
** Just made it ask for your password twice.
**
** David L Robinson
** drobinso@nrg.com.au
**
** 6/27/95
** shadow-adduser 1.4:
**
** now it copies the /etc/skel dir into the person's dir, 
** makes the mail folders, changed some defaults and made a 'make 
** install' just for the hell of it.
**
** Greg Gallagher
** CIN.Net
**
** 1/28/95
** shadow-adduser 1.3:
** 
** Basically a bug-fix on my additions in 1.2.  Thanx to Terry Stewart 
** (stew@texas.net) for pointing out one of the many idiotic bugs I introduced.
** It was such a stupid bug that I would have never seen it myself.
**
**                                Brandon
*****
** 01/27/95
** 
** shadow-adduser 1.2:
** I took the C source from adduser-shadow (credits are below) and made
** it a little more worthwhile.  Many small changes... Here's
** the ones I can remember:
** 
** Removed support for non-shadowed systems (if you don't have shadow,
**     use the original adduser, don't get this shadow version!)
** Added support for the correct /etc/shadow fields (Min days before
**     password change, max days before password change, Warning days,
**     and how many days from expiry date does the account go invalid)
**     The previous version just left all of those fields blank.
**     There is still one field left (expiry date for the account, period)
**     which I have left blank because I do not use it and didn't want to
**     spend any more time on this.  I'm sure someone will put it in and
**     tack another plethora of credits on here. :)
** Added in the password date field, which should always reflect the last
**     date the password was changed, for expiry purposes.  "passwd" always
**     updates this field, so the adduser program should set it up right
**     initially (or a user could keep thier initial password forever ;)
**     The number is in days since Jan 1st, 1970.
**
**                       Have fun with it, and someone please make
**                       a real version(this is still just a hack)
**                       for us all to use (and Email it to me???)
**
**                               Brandon
**                                  photon@usis.com
**
***** 
** adduser 1.0: add a new user account (For systems not using shadow)
** With a nice little interface and a will to do all the work for you.
**
** Craig Hagan
** hagan@opine.cs.umass.edu
**
** Modified to really work, look clean, and find unused uid by Chris Cappuccio
** chris@slinky.cs.umass.edu
**
*****
**
** 01/19/95
**
** FURTHER modifications to enable shadow passwd support (kludged, but
** no more so than the original)  by Dan Crowson - dcrowson@mo.net
**
** Search on DAN for all changes...
**
*****
**
** cc -O -o adduser adduser.c
** Use gcc if you have it... (political reasons beyond my control) (chris)
**
** I've gotten this program to work with success under Linux (without
** shadow) and SunOS 4.1.3. I would assume it should work pretty well
** on any system that uses no shadow. (chris)
**
** If you have no crypt() then try
** cc -DNO_CRYPT -O -o adduser adduser.c xfdes.c
** I'm not sure how login operates with no crypt()... I guess
** the same way we're doing it here.
*/

#include <pwd.h>
#include <grp.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <getopt.h>

#define PASSWD_FILE	"/etc/passwd"

#define SHADOW_FILE	"/etc/shadow"

#define DEFAULT_SHELL	"/bin/bash"	/* because BASH is your friend */
#define DEFAULT_HOME	"/home"

#define DEFAULT_GROUP	100

#define FIRST		500

#define DEFAULT_PERMS	0700	/* Perms for the users home directory */

#define DEFAULT_MIN_PASS 0
#define DEFAULT_MAX_PASS 30
#define DEFAULT_WARN_PASS 15
#define DEFAULT_USER_DIE 10

char uname[9] = "";
char person[32] = "";
char salt[2];

char *dir;
char *shell;
char *passwd;
long group = -1; 
unsigned int uid = 0, pass_change_date = 0; 
unsigned int min_pass = 0, max_pass = 0, warn_pass = 0, user_die = 0;
/* since all these can have values of zero, we need "is it set?" variables */
int min_pass_set = 0, max_pass_set = 0, warn_pass_set = 0, user_die_set = 0;

int public_home_dir = 0;

void *xmalloc(int bytes)
{
	void *vp;
	vp = malloc(bytes);
	if (vp == NULL && bytes > 0) {
		perror("malloc failed");
		exit(-1);
	}
	return vp;
}

char *strd(char *s)
{
        return(strcpy(xmalloc(strlen(s) + 1), s));
}

void get_uname()
{
	char buf[1024];
	while (1) {
		printf("User to add (^C to quit): ");
		fflush(stdout);

		fgets(buf, 1024, stdin);

		buf[strlen(buf) - 1] = '\0';	/* changes '\n' to terminator */

		if (!*buf)	/* hit enter? */
			continue;
		else if (strlen(buf) > 8)
			printf("That username exceeds 8 characters.  Try again.\n");
		else if (getpwnam(buf) != NULL)
			printf("That name is in use, choose another.\n");
		else {
			strcpy(uname, buf);
			break;
		}
	}
}

void get_fullname()
{
	char buf[1024];
	while (1) {
		printf("Full Name: ");
		fflush(stdout);
		fgets(buf, 1024, stdin);
		buf[strlen(buf) - 1] = '\0';
		if (!*buf)
			continue;
		else if (strlen(buf) > 32)	/* I don't know if this is even a limit... ??? -Ben */
			printf("That name exceeds 32 characters.  Please try again.\n");
		else {
			strcpy(person, buf);
			break;
		}
	}
}

void get_gid()
{
	char buf[1024];
        char *failed;
        int def;
        def = group < 0 ? DEFAULT_GROUP : group;
	while (1) {
		printf("GID [%d]: ", def);
		fflush(stdout);
		fgets(buf, 1024, stdin);
		if (*buf == '\n') {
			group = def;
			break;
		} else {
                        buf[strlen(buf) - 1] = '\0'; /*strip newline*/
                        group = strtol(buf, &failed, 0);
                        if ( *failed || group < 0 )
                                printf("Invalid GID.  Please try again.\n");
                        else break;
                }
	}
}

/* Here is our trade secret patented copyrighted code to find an unused UID */

int
find_unused(int begin)
{
	int trial;
	trial = begin - 1;

	printf("Checking for an available UID after %d\n", FIRST);

	while (getpwuid(++trial) != NULL);

	printf("First unused uid is %d\n", trial);

	return (trial);
}


void get_uid()
{
	int def;
	char buf[1024];
        
        if ( uid )
                def = uid;
        else 
                def = find_unused(FIRST + 1);	/* our k-eleet unused! */
	while (1) {
		printf("UID [%d]: ", def);
		fflush(stdout);
		fgets(buf, 1024, stdin);
		if (*buf == '\n') {
			uid = def;
			break;
		} else if ((uid = atoi(buf)) < 1) {
			printf("Invalid UID.  Please try again.\n");
		} else if (getpwuid(uid) != NULL) {
			printf("UID %d already in use.  Please try again.\n", uid);
			uid = 0;
		} else
			break;
	}
}

void get_home()
{
	char buf[1024];
        while (1) {
                if ( dir ) 
                        printf("Home Directory [%s]: ", dir);
                else 
                        printf("Home Directory [%s/%s]: ", DEFAULT_HOME, uname);
                
                fflush(stdout);
                fgets(buf, 1024, stdin);
                if (*buf == '\n') {
                        if ( !dir ) {
                                dir = xmalloc(strlen(DEFAULT_HOME) + strlen(uname) + 2);
                                sprintf(dir, "%s/%s", DEFAULT_HOME, uname);
                        }
                        break;
                } else {
                        if ( dir ) free(dir);
                        buf[strlen(buf) - 1] = '\0';
                        dir = strd(buf);
                        break;
                }
        }
        /* here we make an intelligent guess about the public home directory */
        if ( strncmp(DEFAULT_HOME, dir, strlen(DEFAULT_HOME)) == 0 ) 
                public_home_dir = 0;
        else 
                public_home_dir = 1;
}


void get_shell()
{
	char buf[1024];
        while (1) {
                printf("Shell [%s]: ", shell ? shell : DEFAULT_SHELL);
                fflush(stdout);
                fgets(buf, 1024, stdin);
                if (*buf == '\n') {
                        if ( !shell ) 
                                shell = strd(DEFAULT_SHELL);
                        break;
                } else {
                        buf[strlen(buf) - 1] = '\0';
                        if ( strlen(buf) > 32 ) 
                                printf("response exceeds 32 characters, try again.\n");
                        else {
                                if ( shell ) free(shell);
                                shell = strd(buf);
                                break;
                        }
                }
        }
}

int get_long(int def, char *prompt, ...)
{
        va_list ap;
        char buf[1024];
        char *failed;
        int x;

        va_start(ap, prompt);
        while (1) {
                vprintf(prompt, ap);

                fgets(buf,1024,stdin);
                if (*buf == '\n') 
                        return(def);
                else {
                        x = strtol(buf, &failed, 0);
                        if ( *failed == '\n' )  
                                return(x);
                        else 
                                printf("Invalid entry, please try again.\n");
                }
        }
}

void get_min()
{
        int def = min_pass_set ? min_pass : DEFAULT_MIN_PASS;
        min_pass = get_long(def, "Min. Password Change Days [%d]: ", def);
        min_pass_set = 1;
}

void get_max()
{
        int def = max_pass_set ? max_pass : DEFAULT_MAX_PASS;
        max_pass = get_long(def, "Max. Password Change Days [%d]: ", def);
        max_pass_set = 1;
}

void get_warn()
{
        int def = warn_pass_set ? warn_pass : DEFAULT_WARN_PASS;
        warn_pass = get_long(def, "Password Warning Days [%d]: ", def);
        warn_pass_set = 1;
}

void get_die()
{
        int def = user_die_set ? user_die : DEFAULT_USER_DIE;
        user_die = get_long(def, "Days after Password Expiry for Account Locking [%d]: ", def);
        user_die_set = 1;
}

void get_passwd()
{
	while (1) {	/* Sets up a loop until the password is entered correct twice */
		passwd = strd(getpass("Password: "));
                if ( !*passwd ) 
                        printf("Warning: NULL password!  Hit Return if you really must.\n");
                else if ( strlen(passwd) > 8 )
                        printf("Warning: Depending on %s, characters beyond the first 8 may be ignored.\n",
#ifdef NO_CRYPT
                               "fcrypt()");
#else
                               "crypt()");
#endif
		if (strcmp(passwd, getpass("Retype Password: "))) {
			printf("Sorry, They do not match.\n");
                        free(passwd);
                }
		else 
                        break;
	}
}


void print_info()
{
        printf("\nInformation for new user [%s]:\n", uname);
        printf("Name: %s\n", uname);
        printf("Home directory: %s\n", dir);
        printf("Shell: %s\n", shell);
        printf("Password: <hidden>\n");
        printf("Uid: %d\tGid: %d\n", uid, (int) group);
        printf("Min pass: %d\tmaX pass: %d\n", min_pass, max_pass);
        printf("Warn pass: %d\tLock account: %d\n", warn_pass, user_die);
        printf("public home Directory: %s\n", public_home_dir ? "yes":"no");

        printf("\nType 'y' if this is correct, 'q' to cancel and quit the program,\n");
        printf("or the letter of the item you wish to change: ");        
}


char *crypt();

void
main(int argc, char **argv)
{
	char buf[1024];
	char tmp[255];
        char *failed;

	char commandbuf[80];

	/* the group and uid of the new user.  With command line params, we have to initialize these. */

	int opt = 0, done = 0, do_print = 1;

	/* flags, in order:
	 * opt to parse the arguments
	 * bad to see if the username is in /etc/passwd, or if strange stuff has
	 * been typed if the user might be put in group 0
	 * done allows the program to exit when a user has been added
	 * correct loops until a password is found that isn't in /etc/passwd
	 * gets_warning allows the fflush to be skipped for the first gets
	 * so that output is still legible
	 */

	time_t tm;

	FILE *passwd_file;	/* Yep, it's a file allright */
	FILE *shadow_file;

	/* The real program starts HERE! */

	/* Smile, it's the 2nd best thing you can do with your lips */

	/* Lesse if we know what we're doing here... */

	if (geteuid() != 0) {
		printf("It seems you don't have access to add a new user.  Try\n");
		printf("logging in as root or su root to gain super-user access.\n");
		exit(1);
	}
	while (1) {
		struct option long_opts[] =
		{
			{"user", 1, 0, 'u'},
			{"name", 1, 0, 'n'},
			{"home", 1, 0, 'h'},
			{"uid", 1, 0, 'i'},
			{"group", 1, 0, 'g'},
			{"shell", 1, 0, 's'},
			{"min", 1, 0, 'm'},
			{"max", 1, 0, 'x'},
			{"warn", 1, 0, 'w'},
			{"lock", 1, 0, 'l'},
			{"public-home-dir", 0, 0, 'p'}
		};

		opt = getopt_long(argc, argv, "u:h:i:g:s:m:x:w:l:p", long_opts, NULL);
		if (opt == -1)
			break;
		switch (opt) {
		case 'u':
			if (getpwnam(optarg) != NULL)
				fprintf(stderr, "User \"%s\" already exists.\n", optarg);
			else if (strlen(optarg) > 8)
				fprintf(stderr, "\"%s\" exceeds 8 characters in length.\n", optarg);
			else
				strcpy(uname, optarg);
			break;
		case 'h':
			dir = strd(optarg);
			break;
		case 'i':
			uid = atoi(optarg);
			if (!uid)
				fprintf(stderr, "Invalid uid \"%s\".\n", optarg);
			else if (getpwuid(uid) != NULL) {
				fprintf(stderr, "Uid %s is already in use.\n", optarg);
				uid = 0;
			}
			break;
		case 'g':
                        group = strtol(optarg, &failed, 0);
                        if ( *failed ) {
                                group = -1;
				fprintf(stderr, "Invalid group \"%s\"\n", optarg);
                        }
			break;
		case 's':
			shell = strd(optarg);
			break;
		case 'm':
                        min_pass = (int) strtol(optarg, &failed, 0);
                        if ( !*failed )
                                min_pass_set = 1;
                        else 
                                fprintf(stderr, "Couldn't convert %s to an integer.\n", optarg);
			break;
		case 'x':
                        max_pass = (int) strtol(optarg, &failed, 0);
                        if ( !*failed )
                                max_pass_set = 1;
                        else 
                                fprintf(stderr, "Couldn't convert %s to an integer.\n", optarg);
			break;
		case 'w':
                        warn_pass = (int) strtol(optarg, &failed, 0);
                        if ( !*failed ) 
                                warn_pass_set = 1;
                        else 
                                fprintf(stderr, "Couldn't convert %s to an integer.\n", optarg);
			break;
		case 'l':
                        user_die = (int) strtol(optarg, &failed, 0);
                        if ( !*failed ) 
                                user_die_set = 1;
                        else
                                fprintf(stderr, "Couldn't convert %s to an integer.\n", optarg);
			break;
		case 'p':
			public_home_dir = 1;
                        break;
		default:
			fprintf(stderr, "getopt_long returned character code 0%o.. wtf??\n", opt);
			exit(-1);
		}
	}


	if (!*uname) {
                putchar('\n');
		get_uname();
        }
	printf("\nEditing information for new user [%s]\n", uname);

	if (!*person) {
		putchar('\n');
		get_fullname();
	}
	if (group < 0) {
		putchar('\n');
		get_gid();
	}
	if (!uid) {
		putchar('\n');
		get_uid();
	}
	if (!dir) {
		putchar('\n');
		get_home();

	}
	if (!shell) {
		putchar('\n');
		get_shell();
	}
	if (!min_pass_set) {
                putchar('\n');
                get_min();
	}
	if (!max_pass_set) {
                putchar('\n');
                get_max();
	}
	if (!warn_pass_set) {
                putchar('\n');
                get_warn();
        }
	if (!user_die_set) {
                putchar('\n');
                get_die();
        }
        get_passwd();

        time(&tm);
        salt[0] = (tm & 0x0f) + 'A';
        salt[1] = ((tm & 0xf0) >> 4) + 'a';

        done = 0;
        while (!done) {
                if ( do_print ) 
                        print_info();
                do_print = 1;
                fgets(buf, 1024, stdin);
                switch ( tolower(*buf) ) {
                case 'y':
                        done = 1;
                        break;
                case 'n':
                        get_uname();
                        break;
                case 'h':
                        get_home();
                        break;
                case 's':
                        get_shell();
                        break;
                case 'p':
                        get_passwd();
                        break;
                case 'u':
                        get_uid();
                        break;
                case 'g':
                        get_gid();
                        break;
                case 'm':
                        get_min();
                        break;
                case 'x':
                        get_max();
                        break;
                case 'w':
                        get_warn();
                        break;
                case 'l':
                        get_die();
                        break;
                case 'd':
                        if ( public_home_dir )
                                public_home_dir = 0;
                        else
                                public_home_dir = 1;
                        break;
                case 'q':
                        exit(1);
                        break;
                default:
                        do_print = 0;
                        printf("Invalid response, please try again: ");
                }
        }
                
        
	/* Calculate days since Jan 1st, 1970 for pass_change_date */

	pass_change_date = (int) ((time(NULL) / 86400) - 1);

	printf("\nAdding login [%s] %s", uname,
               public_home_dir ? ".\n" : "and making directory [%s]\n");

	mkdir(dir, DEFAULT_PERMS);

	system("cp /etc/passwd /etc/passwd.OLD");	/* Let's have safe sex */

	sprintf(tmp, "cp %s %s.OLD", SHADOW_FILE, SHADOW_FILE);
	system(tmp);

	passwd_file = fopen(PASSWD_FILE, "a");

	shadow_file = fopen(SHADOW_FILE, "a");

	fprintf(passwd_file, "%s:x:%d:%d:%s:%s:%s\n",
                uname, uid, (int) group, person, dir, shell);
#ifdef NO_CRYPT
	fprintf(shadow_file, "%s:%s:%d:%d:%d:%d:%d::\n", 
                uname, fcrypt(passwd, salt), pass_change_date, 
                min_pass, max_pass, warn_pass, user_die);
#else
	fprintf(shadow_file, "%s:%s:%d:%d:%d:%d:%d::\n", 
                uname, crypt(passwd, salt), pass_change_date, 
                min_pass, max_pass, warn_pass, user_die);
#endif

	fflush(passwd_file);
	fclose(passwd_file);

	fflush(shadow_file);
	fclose(shadow_file);

	/* yes, I fixed uid and group being screwed around (chris) */

	/* make sure that they own their directory -- its kinda nice :) */
	/* chown(dir,uid,group); */

	/* These are the Slackware hacks, added by Patrick Volkerding 12/3/93 */
	/* ...and changed some more on Mon May 2 14:43:34 CDT 1994 */

	/* For UUCP, ftp, pop-only, etc users we don't want to screw with /tmp or 
	   /var/spool/uucppublic or whatever directory we've chosen.  */
	if (!public_home_dir) {
		printf("\nAdding the files from the /etc/skel directory:\n");
		fflush(stdout);

		/* First, we "give" the /etc/skel directory to the new user: */

		sprintf(commandbuf, "chown --recursive %d.%d /etc/skel 2>/dev/null", uid, (int) group);
		system(commandbuf);

		/* Then, we copy the files owned by the new user into the new user's
		   home directory. This way, if there are already files in the user's home
		   directory (say, from a backup), the ownership of those files won't be 
		   changed. Some say this is progress. ;^) */

		sprintf(commandbuf, "( cd /etc/skel ; cp -a --verbose . %s )", dir);
		system(commandbuf);

		/* It's useful to give the new home directory a current
		   creation date rather than the one from /etc/skel. */

		sprintf(commandbuf, "touch %s", dir);
		system(commandbuf);

		/* Give this stuff back to root. By sure to put the uid/gid you want for
		   the default ownership of /etc/skel into the line below if 0.0 isn't good. */

		sprintf(commandbuf, "chown --recursive 0.0 /etc/skel 2> /dev/null");
		system(commandbuf);
		sprintf(commandbuf, "touch /var/spool/mail/%s", uname);
		system(commandbuf);
		sprintf(commandbuf, "chown %d.mail /var/spool/mail/%s", uid, uname);
		system(commandbuf);
		sprintf(commandbuf, "chmod 660 /var/spool/mail/%s", uname);
		system(commandbuf);
		printf("\n\n");
		fflush(stdout);
		/* End SlackHacks */
	}
}

















