/*
    xfmix - audio mixer
    Copyright (C) 1995  Radek Doulik

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __ls_light_box_h__
#define __ls_light_box_h__

#define FL_LIGHTBOX              2100
#define FL_NORMAL_LIGHTBOX       1

FL_OBJECT* fl_create_lightbox(int type, FL_Coord x, FL_Coord y, 
			      FL_Coord w, FL_Coord h, char *);

FL_OBJECT* fl_add_lightbox(int type, FL_Coord x, FL_Coord y,
			   FL_Coord w, FL_Coord h, char *);

int fl_get_lightbox(FL_OBJECT*);
void fl_set_lightbox(FL_OBJECT*, int);
void fl_set_lightbox_width(FL_OBJECT*, int);
void fl_set_lightbox_response(FL_OBJECT*, int);

#endif
