/*
	mp3tag rev.0.0a by Andreas Mueller (cameron).
	Read COPYING for copyright information.
*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

#ifdef __linux__
extern char *basename __P((__const char *__name));
#endif

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE !TRUE
#endif

#define REV "0.0a"


char ownname[255], inputfile[255], buf[255], title[30], album[30], artist[30], comment[30], year[4];
int inputhandle, genre=0;
char inputfilef=FALSE, titlef=FALSE, albumf=FALSE, artistf=FALSE, commentf=FALSE, genref=FALSE,
	yearf=FALSE, force=FALSE, has_tag=FALSE, quiet=FALSE, show_only=FALSE;
char tagsign[]="TAG";


void help()
{
	printf("\n  %s rev."REV" by Andreas Mueller\n", ownname);
	printf("  (cameron@RadioFlora.apc.de) in 1998.\n");
	printf("\n  This program is distributed under the terms of the GNU public license.\n\n");
	printf("  Usage : %s < < -t track > < -r artist > < -a album > < -c comment >\n", ownname);
	printf("          < -y year > < -g genre > < -q > FILE > | < --help > | < --version >\n");
	printf("\n  %s displays the TAG information at the end of an MPEG-1 layer III file,\n", ownname);
	printf(" if found and attemp to change the TAG informations you issued. If only the\n");
	printf(" filename FILE is given, %s will only show the TAG informations.\n", ownname);
	printf("\n   %s returns the following error-codes:\n", ownname);
	printf("\n  1 : Help called.\n");
	printf("  2 : unknown option / parameter.\n");
	printf("  3 : invalid year.\n");
	printf("  4 : invalid genre.\n");
	printf("  5 : unable to open FILE.\n");
	printf("  6 : TAG signature not found.\n"
		"      (Happens only if %s should not change anything)\n\n", ownname);
}

char taginfo(int handle)
{
	char title[30], album[30], artist[30], comment[30], year[4];
	unsigned char genre;

	lseek(handle, -0x80, SEEK_END);
	if(read(handle, buf, 0x80)==0x80)
	{
		if(strncmp(buf, "TAG", 3)!=0)
			return(FALSE);
		else
		{
			strncpy(title, buf+3, 30);
			title[30]=0;
			strncpy(artist, buf+33, 30);
			artist[30]=0;
			strncpy(album, buf+63, 30);
			album[30]=0;
			strncpy(year, buf+93, 4);
			year[4]=0;
			strncpy(comment, buf+97, 30);
			comment[30]=0;
			genre=buf[127];
			fprintf(stderr, "Title  : %s  Artist: %s\n", title, artist);
			fprintf(stderr, "Album  : %s  Year: %4.4s, Genre: %i\n", album, year, genre);
			fprintf(stderr, "Comment: %s\n", comment);
		}
	}
	return(TRUE);
}

int main(int argc, char *argv[])
{
	int l=1;

	strcpy(ownname, basename(argv[0]));
	while(l!=argc) {
		if(argv[l][0]=='-')
			switch(argv[l][1]) {
				case 't':	if(l<(argc-1)) {
							strcpy(title, argv[++l]);
							titlef=TRUE;
						}
						break;
				case 'a':	if(l<(argc-1)) {
							strcpy(album, argv[++l]);
							albumf=TRUE;
						}
						break;
				case 'r':	if(l<(argc-1)) {
							strcpy(artist, argv[++l]);
							artistf=TRUE;
						}
						break;
				case 'c':	if(l<(argc-1)) {
							strcpy(comment, argv[++l]);
							commentf=TRUE;
						}
						break;
				case 'g':	if(l<(argc-1)) {
							genre=atoi(argv[++l]);
							genref=TRUE;
						}
						break;
				case 'y':	if(l<(argc-1)) {
							if(strlen(argv[++l])<5) {
								strcpy(year, argv[l]);
								yearf=TRUE;
							}
							else {
								fprintf(stderr, "%s: Error: Year must be between -999 and 9999.\n", ownname);
								return(3);
							}
						}
						break;
				case 'q':	quiet=TRUE;
						break;
				case 'R':	if(strcmp(argv[l], "-RN")==0) {
							fprintf(stderr, "  The original name of the tool is mp3tag, the revision is 0.0a.\n");
							return 0xff;
						}
				case '-':	if(strcmp(argv[l], "--help")==0) {
							help();
							return(1);
						}
				default:	fprintf(stderr, "%s: Unknown option: %s.\n", ownname, argv[l]);
						fprintf(stderr, "%s: Try \"%s --help\" for usage information.\n", ownname, ownname);
						return(2);
			}
		else {
			if(!inputfilef) {
				strcpy(inputfile, argv[l]);
				inputfilef=TRUE;
			}
			else {
				fprintf(stderr, "%s: Unknown parameter: %s.\n", ownname, argv[l]);
				fprintf(stderr, "%s: Try \"%s --help\" for usage information.\n", ownname, ownname);
				return(2);
			}
		}
		l++;
	}
	if((genre<0)|(genre>255)) {
		fprintf(stderr, "%s: Error: Genre (-g) must be between 0 and 255.\n", ownname);
		return(4);
	}
	if(inputfilef&!titlef&!albumf&!artistf&!commentf&!yearf&!genref)
		show_only=TRUE;
	if(inputfilef) {
		inputhandle=open(inputfile, show_only ? O_RDONLY : O_RDWR);
		if(inputhandle<0) {
			fprintf(stderr, "%s: unable to open \"%s\"%s!\n", ownname, inputfile, show_only ? "" : " for writing");
			return(5);
		}
	}
	if(inputfilef) {
		fprintf(stderr, "%sag information about %s:\n", show_only ? "T" : "Old t", inputfile);
		has_tag=taginfo(inputhandle);
		if(!has_tag)
			fprintf(stderr, "TAG-signature not found.\n");
	}
	if(!has_tag&show_only)
		return(6);
	if(!quiet&!show_only) {
		if(!has_tag) {
			if(!titlef)
				fprintf(stderr, "%s: WARNING: Missing title (-t).\n", ownname);
			if(!albumf)
				fprintf(stderr, "%s: WARNING: Missing album (-a).\n", ownname);
			if(!artistf)
				fprintf(stderr, "%s: WARNING: Missing artist (-r).\n", ownname);
			if(!commentf)
				fprintf(stderr, "%s: WARNING: Missing comment (-c).\n", ownname);
			if(!genref)
				fprintf(stderr, "%s: WARNING: Missing genre (-g).\n", ownname);
			if(!yearf)
				fprintf(stderr, "%s: WARNING: Missing year (-y).\n", ownname);
		}
		else {
			if(titlef)
				fprintf(stderr, "%s: Changing title to %s.\n", ownname, title);
			if(albumf)
				fprintf(stderr, "%s: Changing album to %s.\n", ownname, album);
			if(artistf)
				fprintf(stderr, "%s: Changing artist to %s.\n", ownname, artist);
			if(commentf)
				fprintf(stderr, "%s: Changing comment to %s.\n", ownname, comment);
			if(genref)
				fprintf(stderr, "%s: Changing genre to %i.\n", ownname, genre);
			if(yearf)
				fprintf(stderr, "%s: Changing year to %s.\n", ownname, year);
		}
	}
	for(l=strlen(title); l!=30; l++)
		title[l]=' ';
	for(l=strlen(artist); l!=30; l++)
		artist[l]=' ';
	for(l=strlen(album); l!=30; l++)
		album[l]=' ';
	for(l=strlen(year); l!=4; l++)
		year[l]=' ';
	for(l=strlen(comment); l!=30; l++)
		comment[l]=' ';
	if(inputfilef&!show_only) {
		if(has_tag)
			lseek(inputhandle, -0x80, SEEK_END);
		else
			lseek(inputhandle, 0, SEEK_END);
		write(inputhandle, "TAG", 3);
		if(titlef|!has_tag) {
			if(has_tag)
				lseek(inputhandle, -0x7d, SEEK_END);
			write(inputhandle, title, 30);
		}
		if(artistf|!has_tag) {
			if(has_tag)
				lseek(inputhandle, -0x5f, SEEK_END);
			write(inputhandle, artist, 30);
		}
		if(albumf|!has_tag) {
			if(has_tag)
				lseek(inputhandle, -0x41, SEEK_END);
			write(inputhandle, album, 30);
		}
		if(yearf|!has_tag) {
			if(has_tag)
				lseek(inputhandle, -0x23, SEEK_END);
			write(inputhandle, year, 4);
		}
		if(commentf|!has_tag) {
			if(has_tag)
				lseek(inputhandle, -0x1f, SEEK_END);
			write(inputhandle, comment, 30);
		}
		if(genref|!has_tag) {
			if(has_tag)
				lseek(inputhandle, -1, SEEK_END);
			buf[0]=genre;
			write(inputhandle, buf, 1);
		}
	}
	if(!inputfilef) {
		title[30]=album[30]=artist[30]=year[4]=0;
		printf("TAG%s%s%s%s%s%c", title, artist, album, year, comment, genre);
	}
	if(!show_only&inputfilef)
	{
		fprintf(stderr, "New tag information about %s:\n", inputfile);
		taginfo(inputhandle);
	}
	close(inputhandle);
	return(0);
}

