/*

Name:
LOAD_669.C

Description:

669 module Loader - Version 0.21
Updated to current portability levels by Steve McIntyre 
		<stevem@chiark.greenend.org.uk>
December 1996

Unreliable and doesn't work fully yet - plays too fast, sounds very bad...

Portability:
All systems - all compilers (hopefully)

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "mikmod.h"

/* Raw 669 header struct: */

typedef struct S69HEADER{
	UWORD marker;
	char  message[108];
	UBYTE nos;
	UBYTE nop;
	UBYTE looporder;
	UBYTE orders[0x80];
	UBYTE tempos[0x80];
	UBYTE breaks[0x80];
} S69HEADER;



/* Raw 669 sampleinfo struct: */

typedef struct S69SAMPLE{
	char  filename[13];
	long  length;
	long  loopbeg;
	long  loopend;
} S69SAMPLE;


/* Raw 669 Note struct */

typedef struct S69NOTE{
	UBYTE a,b,c;
} S69NOTE;




static S69NOTE *s69pat;
static S69HEADER *mh;

char *S69_Version[]={
	"669",
	"Extended 669"
};



BOOL S69_Test(void)
{
        char id[2];
	_mm_fseek(modfp,0,SEEK_SET);
        if(!fread(id,2,1,modfp)) return 0;
        if(!memcmp(id,"if",2)) return 1;
        if(!memcmp(id,"JN",2)) return 1;
        return 0;
}



BOOL S69_Init(void)
{
	mh=NULL;
	s69pat=NULL;

	if(!(s69pat=(S69NOTE *)MyMalloc(64*8*sizeof(S69NOTE)))) return 0;
	if(!(mh=(S69HEADER *)MyCalloc(1,sizeof(S69HEADER)))) return 0;
	return 1;
}



void S69_Cleanup(void)
{
	if(s69pat!=NULL) free(s69pat);
	if(mh!=NULL) free(mh);
}




BOOL S69_LoadPatterns(void)
{
	int u,t,s,tracks=0,q;
	UBYTE note,inst,vol,a,b,c;

	if(!AllocPatterns()) return 0;
	if(!AllocTracks()) return 0;

	for(t=0;t<of.numpat;t++){

		of.pattrows[t]=mh->breaks[t]+1;

		/* Load the pattern into the temp buffer
		   and convert it into the 3-byte format */

		if(fread(s69pat,64*8*sizeof(S69NOTE),1,modfp)!=1){
			myerr=ERROR_LOADING_PATTERN;
			return 0;
		}

		for(s=0;s<8;s++){

			UniReset();

			UniPTEffect(0xf,78);
			UniPTEffect(0xf,3);

			for(q=0;q<64;q++){

				a=s69pat[(q*8)+s].a;
				b=s69pat[(q*8)+s].b;
				c=s69pat[(q*8)+s].c;

				note=a>>2;
				inst=((a&0x3)<<4)|((b&0xf0)>>4);
				vol=b&0xf;

				if(note<0x3e){
					UniInstrument(inst);
					UniNote(note+24);
				}

				if(note<0x3f){
					UniPTEffect(0xc,vol<<2);
				}

				UniNewline();
			}
			if(!(of.tracks[tracks++]=UniDup())) return 0;
		}
	}
	return 1;
}


BOOL S69_Load(void)
{
	int t,u,track=0;
/*	UNIMOD of; /* testing... */
	S69SAMPLE s;
	ULONG temp_loopend;
	INSTRUMENT *d;
	SAMPLE *q;
	UBYTE isused[16];
	UBYTE pan[32];

	/* try to read module header */

        char id[2];
	_mm_fseek(modfp,0,SEEK_SET);
        if(!fread(id,2,1,modfp)) return 0;
	_mm_rewind(modfp);

	mh->marker		=_mm_read_I_UWORD(modfp);
	_mm_read_str(mh->message,108,modfp);
	mh->nos			=_mm_read_UBYTE(modfp);
	mh->nop			=_mm_read_UBYTE(modfp);
	mh->looporder		=_mm_read_UBYTE(modfp);
	for(t=0;t<128;t++){
		mh->orders[t]=_mm_read_UBYTE(modfp);
	}
	for(t=0;t<128;t++){
		mh->tempos[t]=_mm_read_UBYTE(modfp);
	}
	for(t=0;t<128;t++){
		mh->breaks[t]=_mm_read_UBYTE(modfp);
	}

        if(feof(modfp)){
                myerr="Error loading header";
                return 0;
        }

	/* set module variables */

	of.initspeed=6;
	of.inittempo=125;
	of.songname=DupStr(mh->message,108);
        if(memcmp(id,"JN",2))
		of.modtype=strdup(S69_Version[1]);
	else
		of.modtype=strdup(S69_Version[0]);
	of.numchn=8;
	of.numpat=mh->nop;
	of.numins=mh->nos;
	of.numtrk=of.numchn*of.numpat;

	memcpy(of.positions,mh->orders,0x80);

	for(t=0;t<128;t++){
		if(of.positions[t]==0xff) break;
	}
	of.numpos=t;

	if(!AllocInstruments()) return 0;

	d=of.instruments;

	for(t=0;t<of.numins;t++){

		d->numsmp=1;
		if(!AllocSamples(d)) return 0;
        q=d->samples;

		/* try to read sample info */

	        _mm_read_str(s.filename,13,modfp);

		q->seekpos=0;
		q->c2spd=8363;
		q->length=_mm_read_I_ULONG(modfp);
		s.loopbeg=_mm_read_I_ULONG(modfp);
		temp_loopend=_mm_read_I_ULONG(modfp);
		q->loopend=(temp_loopend<q->length) ? temp_loopend : q->length;

		q->flags=(s.loopbeg<q->loopend)?SF_LOOP:0;

		q->volume=64;
		d++;
	}

        if(feof(modfp)){   
                myerr="Error loading samples";
                return 0;
        }

	if(!S69_LoadPatterns()) return 0;

	return 1;
}




LOADER load_669={
	NULL,
	"669",
	"669 loader v0.21 - last updated 12/96 SAM",
	S69_Init,
	S69_Test,
	S69_Load,
	S69_Cleanup
};
