/*
 * XOTPCalc, an S/Key and OPIE compatible one-time password calculator
 * Copyright (C) 1997 Ivan Nejgebauer <ian@uns.ns.ac.yu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _XOTPCALC_H
#define _XOTPCALC_H

typedef struct hostinfo *Hinfo;

/* global data */
extern Widget top;
extern Widget hostlist;
extern XtAppContext app;
extern int save_on_exit;

/* default resources */
extern char *defres[];

/* private resource record */
typedef struct {
    Boolean allow_insecure;
    Boolean save_position;
    Boolean save_dimensions;
    String response_font;
    int initial_seq;
} PrivResRec;
extern PrivResRec AppRes;

/* functions in main.c */
Boolean ask_noyes(char *msg);
void err_report(Widget w, char *msg, char *emsg);
void DoQuit(Widget w, XEvent *ev, String *params, Cardinal *num_params);

/* functions in menu.c */
void menu_create(void);
void sensitize_edit_delete(Boolean what);
void MainMenuPopup(Widget w, XEvent *ev, String *params, Cardinal *num_params);

/* functions in list.c */
void list_create(void);
void list_init_geometry(void);
void get_shell_geometry(Dimension *x, Dimension *y, Dimension *w, Dimension *h);
void add_host_to_list(Widget w, Hinfo h);
void DoDeleteHost(Widget w, XEvent *ev, String *params, Cardinal *num_params);

/* functions in dialog.c */
void DoNewHost(Widget w, XEvent *ev, String *params, Cardinal *num_params);
void DoEditHost(Widget w, XEvent *ev, String *params, Cardinal *num_params);
void do_calculate(void);
void dialog_create(void);

#endif
