/*
 * XOTPCalc, an S/Key and OPIE compatible one-time password calculator
 * Copyright (C) 1997 Ivan Nejgebauer <ian@uns.ns.ac.yu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Popup menu creation and handling.
 */

#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include "xotpcalc.h"

typedef void (*ActionFunc)(Widget, XEvent *, String *, Cardinal *);

/* local functions */
static void Option_CB(Widget w, XtPointer client_data, XtPointer call_data);

/* local data */
static Widget menu;
static Widget pb_edit, pb_delete;

/*
 * Build the menu.
 */
void
menu_create(void)
{
    Widget pb, sep;
    XmString s;
    Arg av[5];
    int ac;

    menu = XmCreatePopupMenu(hostlist, "main_menu", NULL, 0);

    ac = 0;
    s = XmStringCreateSimple("Alt+N");
    XtSetArg(av[ac], XmNacceleratorText, s); ac++;
    XtSetArg(av[ac], XmNmnemonic, 'N'); ac++;
    pb = XtCreateManagedWidget(
	"New Host", xmPushButtonWidgetClass,
	menu,
	av, ac);
    XtAddCallback(pb, XmNactivateCallback, Option_CB, (XtPointer) DoNewHost);

    ac = 0;
    s = XmStringCreateSimple("Alt+E");
    XtSetArg(av[ac], XmNacceleratorText, s); ac++;
    XtSetArg(av[ac], XmNmnemonic, 'E'); ac++;
    pb_edit = XtCreateManagedWidget(
	"Edit Host", xmPushButtonWidgetClass,
	menu,
	av, ac);
    XtAddCallback(pb_edit, XmNactivateCallback, Option_CB,
		  (XtPointer) DoEditHost);

    ac = 0;
    s = XmStringCreateSimple("Alt+D");
    XtSetArg(av[ac], XmNacceleratorText, s); ac++;
    XtSetArg(av[ac], XmNmnemonic, 'D'); ac++;
    pb_delete = XtCreateManagedWidget(
	"Delete Host", xmPushButtonWidgetClass,
	menu,
	av, ac);
    XtAddCallback(pb_delete, XmNactivateCallback, Option_CB,
		  (XtPointer) DoDeleteHost);

    sep = XtCreateManagedWidget(
	"main_sep0", xmSeparatorWidgetClass,
	menu,
	NULL, 0);

    ac = 0;
    XtSetArg(av[ac], XmNmnemonic, 'x'); ac++;
    s = XmStringCreateSimple("Alt+Q");
    XtSetArg(av[ac], XmNacceleratorText, s); ac++;
    pb = XtCreateManagedWidget(
	"Exit", xmPushButtonWidgetClass,
	menu,
	av, ac);
    XtAddCallback(pb, XmNactivateCallback, Option_CB, (XtPointer) DoQuit);
}

/*
 * Display the menu.
 */
void
MainMenuPopup(Widget w, XEvent *ev, String *params, Cardinal *num_params)
{
    XmMenuPosition(menu, &(ev->xbutton));
    XtManageChild(menu);
}

/*
 * Turn "Edit Host" and "Delete Host" buttons on or off.  They should be
 * off when the host array is empty.
 */
void
sensitize_edit_delete(Boolean what)
{
    XtSetSensitive(pb_edit, what);
    XtSetSensitive(pb_delete, what);
}

/*
 * Menu option callback.  The function to be called is passed in
 * client_data.
 */
static void
Option_CB(Widget w, XtPointer client_data, XtPointer call_data)
{
    ActionFunc action_func = (ActionFunc) client_data;

    action_func(hostlist, NULL, NULL, NULL);
}
