/*
 * XOTPCalc, an S/Key and OPIE compatible one-time password calculator
 * Copyright (C) 1997 Ivan Nejgebauer <ian@uns.ns.ac.yu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _HOSTS_H
#define _HOSTS_H

/* hash algorithms */
enum { MD4, MD5 };

/* host data */
struct hostinfo {
    char *name;
    int algorithm;
    int sequence;
    char *seed;
};

/* global data */
extern struct hostinfo **h_list;
extern struct hostinfo *h_selected;
extern int h_count;

/* functions */
int hosts_init(char **err_return);
int host_add(struct hostinfo *h, int selected, char **err_return);
int host_delete(char *name, char **err_return);
int host_lookup(char *name);
int host_partial_lookup(char *name);
int hosts_write(char **err_return);

#endif
