#ifndef _CONFIG_H
#define _CONFIG_H

/* File   : config.h                                                         */
/* Purpose: User configurable options for the uwatch program.                */

/* Select the operating system (OS) for which you are compiling uwatch.  To  */
/* select a system, remove the leading /* before the #define statement       */
/* corresponding to the appropriate OS.  Be sure that only one OS is         */
/* defined, (in other words, all other #define statements other than the     */
/* one you want are preceeded by /*).                                        */
/*#define BSDI /* */
#define LINUX /* */

/* The default format string to use when informing the user that someone has */
/* either logged on or off of the system.  The following special characters  */
/* are recgonized:                                                           */
/*                                                                           */
/*    %%  Print a % character         %b  Print a bell                       */
/*    %n  Print a new line            %u  Print the user name                */
/*    %e  Print an escape character   %p  Print the port                     */
/*    %r  Print the remote host       %t  Print the current time             */
/*    %h  Print the local host name                                          */
#define DEF_OUT_FORMAT "%bOut: %u%n"
#define DEF_IN_FORMAT "%bIn: %u%n"

/* The configuration files that uwatch reads.  First, SYSTEM_CONFIG is       */
/* parsed.  Then, the USER_CONFIG file will be looked for in the user's home */
/* directory and parsed.  Finally, the SECURE_CONFIG file is parsed.  This   */
/* file should contain defaults that you do not want the user to be able to  */
/* change with their configuration files.  The files need not exist.  If you */
/* want to turn off the scanning of any of the files, undefine them below by */
/* putting a /* in front of the #define statement.                           */
#define USER_CONFIG ".uwatchrc" /* */
#define SYSTEM_CONFIG "/etc/uwatchrc" /* */
#define SECURE_CONFIG "/etc/uwatchrc.secure" /* */

/* The minimum value that the sleep time, (time between checks of the system */
/* for new login or logout activity), may have.  To turn off this feature,   */
/* put a /* in front of the the #define statement.                           */
#define MIN_SLEEP_TIME 2  /* */

/********** You probably do not care about these values **********************/

/* The size of the hash to hold names.                                       */
#define NAME_HASH_SIZE 13

/* The size of the input buffer.  Usually, this can be left alone, but it    */
/* can be tweaked for your I/O.  This is not a maximum value for the input;  */
/* it just defines how large a chunk is requested for reading.  Also, input  */
/* buffers are allocated in chunks of INBUF size.  To save (a small amount   */
/* of) memory, this value can be lowered.  If input is continuously larger   */
/* than INBUF, then time will be spent reallocating memory to hold all the   */
/* input.  If INBUF is set below 2, a default value will be used.            */
#define INBUF 512

#endif  /* __CONFIG_H */
