/*******************************************************************
* Simple utility to take a key for the termlock program and jumble *
* it, then writing it back to stdout.				   *
*******************************************************************/

#include <plh_io.h>
#include <plh_general.h>
#include <plh_bits.h>
#include "termlock.h"

void main(void)
{
  char key[LARGE_BUFFER_SIZE],
       jumble[LARGE_BUFFER_SIZE];
  unsigned int x, keylen;
  
  FGetString(key, LARGE_BUFFER_SIZE, stdin);
  keylen = strlen(key);
  
  for(x = 0; x < keylen; x++)
    jumble[x] = *(BitMirror8(key + x));
  jumble[x] = '\0';
  
  for(x = 0; x < keylen; x++)
    printf("%d,", jumble[x]);
  printf("%d", jumble[x]);
}
