#include <ctype.h>
#include <string.h>
#include <plh_ptr.h>

char *TrimString(char *s, char mode)
 {
			/* Index of the beginning of non-whitespace string    */
   int start,
   			/* Index of the end of non-whitespace string	      */
       end,
       			/* Working index for compaction character movement    */
       windex,
       			/* Working index for scanning string		      */
       sindex;
       
			/* Check for null pointer immediately to avoid a      */
			/* segmentation fault occuring			      */
   if(IS_NULL(s)) return NULL;
   
			/* Find beginning of non-whitespace string            */   
   for(start = 0; isspace(s[start]) && (s[start] != '\0'); start++);

   			/* Find end of non-whitespace string		      */
   for(end = strlen(s) - 1; isspace(s[end]) && (end != 0); end--);

   			/* NOTE: this compaction-like technique does add      */
   			/* overhead- especially when not using TRIM_EMBED;    */
   			/* however, having the string on the original left    */
   			/* bound of memory (conceptually) removes some        */
   			/* possibility of error if the memory is dynamic.     */

			/* Quick method of removing leading whitespace in a   */
			/* compaction technique is to simply initialize the   */
			/* writing pointer (windex) to the beginning while    */
			/* the reading pointer (sindex) is set to the start   */
			/* of the meaningful data. If trimming the leading    */
			/* space is unwanted, just initialize the write index */
			/* to the beginning of the meaningful data also.      */   			
    if(mode & TRIM_FRONT) windex = 0; else windex = start;
    sindex = start;

			/* Section of code to compact all meaningful data     */
			/* while removing whitespace if embedded trimming is  */
			/* desired.					      */
    while(sindex <= end)
      if(!isspace(s[sindex]))
         s[windex++] = s[sindex++];
      else
         if(!(mode & TRIM_EMBED))
            s[windex++] = s[sindex++];
         else
            sindex++;

			/* Code to copy the trailing whitespace if so desired */
   if(!(mode & TRIM_REAR))
      while(s[sindex] != '\0')
        s[windex++] = s[sindex++];

			/* Mark the end of the string and return it	      */
   s[windex] = '\0';
   return s;        
 }
