#include <stdio.h>
#include <plh_ptr.h>
#include <plh_io.h>
#include <plh_parse.h>

#define TESTFILE	"options.testfile"

void main(void)
 {
  FILE *fptr = OpenOrExit(TESTFILE, "r");
  options *opts = ReadOptionsFile(fptr,
  	          REMOVE_COMMENTS | GET_VARS | GET_DIRS, '#', '.');
  optvar_node *varscan = opts->vars;
  optdir_node *dirscan = opts->dirs;
  
  printf("Variables read...\n");
  while(!IS_NULL(varscan))   				  
   {
     printf("  Label:[%s] Value:[%s]\n", varscan->label, varscan->value);
     varscan = varscan->next;
   }
   
  printf("Directives read...\n");
  while(!IS_NULL(dirscan))   				  
   {
     printf("  Directive:[%s]\n", dirscan->directive);
     dirscan = dirscan->next;
   }
 }
 
