#include <string.h>
#include <plh_ptr.h>
#include <plh_parse.h>
#include <plh_memory.h>

#define SAVEANDCLIP(chr)	{ save = chr; chr = '\0'; } 
#define RESTORE(chr)		{ chr = save; }

void SplitString(char *s, char del, char **left, char **right, char flags)
 {
 			/* Pointer for scanning the passed string	      */
   char *scanner;
   			/* Variable for saving character during temporary     */
   			/* string clips & copied (saves the clipped character)*/
   char save;
			/* The length of the input string passed	      */
   char bufflen = strlen(s);

			/* find the delimeter from specified location	      */
   switch(flags & SEARCH_MASK)
    {
    	case SEARCH_FRONT:
    			/* find delimeter from front			      */
          for(scanner = s;
              (*scanner != '\0') && (*scanner != del); scanner++);
          break;
           
        case SEARCH_END:
    			/* find delimeter from rear 			      */
          for(scanner = s + bufflen;
              (scanner != s) && (*scanner != del); scanner--);
          break;
    }

			/* If delimeter wasn't found, then abort operation    */
   if (*scanner != del) return;

			/* allocate storage and copy strings based on the     */
			/* delimeter options				      */
   if(!(IS_NULL(left) && IS_NULL(right))) 
     switch(flags & DELIM_MASK)
      {
       case DELIM_LEFT:
			/* store delimeter with the left string		      */
        if(!IS_NULL(right))
         { 
          MemCheck(*right = malloc((s + bufflen - scanner + 1) * sizeof(char)));
	  strcpy(*right, scanner + 1);
         }

        if(!IS_NULL(left))
         {
          MemCheck(*left = malloc((scanner - s + 2) * sizeof(char)));
	  SAVEANDCLIP(*(scanner + 1));
	  strcpy(*left, s);
	  RESTORE(*(scanner + 1));
	 }

	break;
	
       case DELIM_RIGHT:
			/* store delimeter with the right string	      */
        if(!IS_NULL(right))
         { 
          MemCheck(*right = malloc((s + bufflen - scanner + 2) * sizeof(char)));
	  strcpy(*right, scanner);
         }

        if(!IS_NULL(left))
         {
          MemCheck(*left = malloc((scanner - s + 1) * sizeof(char)));
	  SAVEANDCLIP(*scanner);
	  strcpy(*left, s);
	  RESTORE(*scanner);
	 }
	 
	break;

       case DELIM_NEITHER:
			/* store delimeter with neither string		      */
        if(!IS_NULL(right))
         { 
          MemCheck(*right = malloc((s + bufflen - scanner + 1) * sizeof(char)));
	  strcpy(*right, scanner + 1);
         }

        if(!IS_NULL(left))
         {
          MemCheck(*left = malloc((scanner - s + 1) * sizeof(char)));
	  SAVEANDCLIP(*scanner);
	  strcpy(*left, s);
	  RESTORE(*scanner);
	 }
	 
	break;

       case DELIM_BOTH:
			/* store delimeter with both strings		      */
        if(!IS_NULL(right))
         { 
          MemCheck(*right = malloc((s + bufflen - scanner + 2) * sizeof(char)));
	  strcpy(*right, scanner);
         }

        if(!IS_NULL(left))
         {
          MemCheck(*left = malloc((scanner - s + 2) * sizeof(char)));
	  SAVEANDCLIP(*(scanner + 1));
	  strcpy(*left, s);
	  RESTORE(*(scanner + 1));
	 }
	 
	break;
      }         
 }
 
