#include <stdio.h>
#include <string.h>
#include <plh_general.h>
#include <plh_parse.h>
#include <plh_ptr.h>
#include <plh_memory.h>
#include <plh_io.h>

options *ReadOptionsFile(FILE *optfile, char flags, char cdel, char ddel)
 {
			/* Pointer to return structure for options	      */
   options *fileopts;
   			/* Pointer to variable structure list (for options)   */
   optvar_node *varhead = NULL;
   			/* Pointer to current variable structure	      */
   optvar_node *curvar = NULL;
   			/* Pointer for temporary allocation of new structures */
   optvar_node *tempvar;
   			/* Pointer to directive structure list (for options)  */
   optdir_node *dirhead = NULL;
   			/* Pointer to current directive structure	      */
   optdir_node *curdir = NULL;
   			/* Pointer for temporary allocation of new structures */
   optdir_node *tempdir;
   			/* Buffer for reading data from file		      */
   char buffer[LARGE_BUFFER_SIZE];
			/* Variable counter for counting the line number      */
   long lineno = 0;

			/* Read in lines without leading & following white    */
			/* space.					      */
   while(!IS_NULL(FGetStringClipped(buffer, LARGE_BUFFER_SIZE, optfile)))
    {
			/* Increment line number counter		      */
      lineno++;

			/* If specified, remove comments & re-trim whitespace */
      if(flags & REMOVE_COMMENTS)
         TrimString(CharReplace(buffer, cdel, '\0', CHRREP_ALL), 
                    TRIM_FRONT | TRIM_REAR);
			/* Continue processing of this buffer to allow for    */
			/* inline comments.				      */

			/* Next priority is to get directives. These are      */
			/* commands marked by a directive marker like '.BOLD' */
			/* where '.' is the directive delimeter. They mostly  */
			/* aren't handled like variables (i.e. you don't see  */
			/* '.FONT=courier'), but check for them prior to      */
			/* variables to leave that possibility open.	      */
      if((flags & GET_DIRS) && (buffer[0] == ddel))
       {
			/* Allocate a new node and get directive data         */
         MemCheck(tempdir = (optdir_node*)malloc(sizeof(optdir_node)));
	 ParseDirective(buffer, &(tempdir->directive));
         
         if(IS_NULL(dirhead))
           curdir = dirhead = tempdir;
         else
          {
           curdir->next = tempdir;
           curdir = tempdir;
          }
         curdir->next = NULL;
         tempdir = NULL;           
       }
      else		/* Test for a variable assignment		      */
        if((flags & GET_VARS) && strchr(buffer, '='))
         {
         		/* Variables consist of two parts, a lvalue (label)   */
         		/* and a rvalue (assigned value). Each of these is    */
         		/* stored in the structure as trimmed strings after   */
         		/* being separated.				      */

			/* Allocate a new node and get variable data          */
           MemCheck(tempvar = (optvar_node*)malloc(sizeof(optvar_node)));
	   ParseVariable(buffer, &(tempvar->label), &(tempvar->value));

			/* Link structure into existing list.		      */
           if(IS_NULL(varhead))
             curvar = varhead = tempvar;
           else
            {
             curvar->next = tempvar;
             curvar = tempvar;
            }
           curvar->next = NULL;
           tempvar = NULL;           	   
         }
        else
          if(!IS_EMPTY(buffer))
            fprintf(stderr,
                    "ReadOptionsFile: Unrecognized option at line %ld\n",
                    lineno);
    }

   			/* Allocate the memory for the return structure and   */
   			/* link built lists into it.			      */
   MemCheck(fileopts = (options*)malloc(sizeof(options)));   
   fileopts->vars = varhead;
   fileopts->dirs = dirhead;

   return fileopts;
 }
