#include <stdio.h>
#include <plh_bits.h>

#define TEST8	213
#define TEST16	39916
#define TEST32	3543247432

void main(void)
 {
   bit8 byte;
   bit16 word;
   bit32 dword;
   
   printf("Testing bit function macros...\n");
   printf("  OR:\n");
   printf("    0 OR 0 = %d\n", OR(0,0)); 
   printf("    0 OR 1 = %d\n", OR(0,1)); 
   printf("    1 OR 0 = %d\n", OR(1,0)); 
   printf("    1 OR 1 = %d\n", OR(1,1)); 
   printf("  AND:\n");
   printf("    0 AND 0 = %d\n", AND(0,0)); 
   printf("    0 AND 1 = %d\n", AND(0,1)); 
   printf("    1 AND 0 = %d\n", AND(1,0)); 
   printf("    1 AND 1 = %d\n", AND(1,1)); 
   printf("  XOR/EOR:\n");
   printf("    0 XOR 0 = %d\n", XOR(0,0)); 
   printf("    0 XOR 1 = %d\n", XOR(0,1)); 
   printf("    1 XOR 0 = %d\n", XOR(1,0)); 
   printf("    1 XOR 1 = %d\n", XOR(1,1)); 
   printf("done.\n\n");
   
   printf("Testing bit structures...\n");
   byte.bytes.byte0 = TEST8;
   word.words.word0 = TEST16;
   dword.dwords.dword0 = TEST32;
   printf("  8 bit strucutre:\n");
   printf("    Number: %u (%X)\n", TEST8, TEST8);
   printf("    Bytes: %X\n",
   		byte.bytes.byte0);
   printf("    Nibbles: %X %X\n",
   		byte.nibbles.nib1,
   		byte.nibbles.nib0);
   printf("    Binary: %X%X%X%X %X%X%X%X\n",
   		byte.bits.bit7,
   		byte.bits.bit6,
   		byte.bits.bit5,
   		byte.bits.bit4,
   		byte.bits.bit3,
   		byte.bits.bit2,
   		byte.bits.bit1,
   		byte.bits.bit0);
   printf("    Size in Bytes (1): %d\n", sizeof(bit8));
   printf("  16 bit strucutre:\n");
   printf("    Number: %u (%X)\n", TEST16, TEST16);
   printf("    Words: %X\n",
   		word.words.word0);
   printf("    Bytes: %X %X\n",
   		word.bytes.byte1,
   		word.bytes.byte0);
   printf("    Nibbles: %X %X %X %X\n",
   		word.nibbles.nib3,
   		word.nibbles.nib2,
   		word.nibbles.nib1,
   		word.nibbles.nib0);
   printf("    Binary: %X%X%X%X %X%X%X%X %X%X%X%X %X%X%X%X\n",
   		word.bits.bit15,
   		word.bits.bit14,
   		word.bits.bit13,
   		word.bits.bit12,
   		word.bits.bit11,
   		word.bits.bit10,
   		word.bits.bit9,
   		word.bits.bit8,
   		word.bits.bit7,
   		word.bits.bit6,
   		word.bits.bit5,
   		word.bits.bit4,
   		word.bits.bit3,
   		word.bits.bit2,
   		word.bits.bit1,
   		word.bits.bit0);
   printf("    Size in Bytes (2): %d\n", sizeof(bit16));
   printf("  32 bit strucutre:\n");
   printf("    Number: %lu (%X)\n", TEST32, TEST32);
   printf("    DoubleWords: %X\n",
   		dword.dwords.dword0);
   printf("    Words: %X %X\n",
   		dword.words.word1,
   		dword.words.word0);
   printf("    Bytes: %X %X %X %X\n",
   		dword.bytes.byte3,
   		dword.bytes.byte2,
   		dword.bytes.byte1,
   		dword.bytes.byte0);
   printf("    Nibbles: %X %X %X %X %X %X %X %X\n",
   		dword.nibbles.nib7,
   		dword.nibbles.nib6,
   		dword.nibbles.nib5,
   		dword.nibbles.nib4,
   		dword.nibbles.nib3,
   		dword.nibbles.nib2,
   		dword.nibbles.nib1,
   		dword.nibbles.nib0);
   printf("    Binary: %X%X%X%X %X%X%X%X %X%X%X%X %X%X%X%X %X%X%X%X %X%X%X%X %X%X%X%X %X%X%X%X\n",
   		dword.bits.bit31,
   		dword.bits.bit30,
   		dword.bits.bit29,
   		dword.bits.bit28,
   		dword.bits.bit27,
   		dword.bits.bit26,
   		dword.bits.bit25,
   		dword.bits.bit24,
   		dword.bits.bit23,
   		dword.bits.bit22,
   		dword.bits.bit21,
   		dword.bits.bit20,
   		dword.bits.bit19,
   		dword.bits.bit18,
   		dword.bits.bit17,
   		dword.bits.bit16,
    		dword.bits.bit15,
   		dword.bits.bit14,
   		dword.bits.bit13,
   		dword.bits.bit12,
   		dword.bits.bit11,
   		dword.bits.bit10,
   		dword.bits.bit9,
   		dword.bits.bit8,
   		dword.bits.bit7,
   		dword.bits.bit6,
   		dword.bits.bit5,
   		dword.bits.bit4,
   		dword.bits.bit3,
   		dword.bits.bit2,
   		dword.bits.bit1,
   		dword.bits.bit0);
   printf("    Size in Bytes (4): %d\n", sizeof(bit32));
   printf("done.\n");
   
 }
 
