/*******************************************************************************
* plh_ptr.h								       *
********************************************************************************
* Collection of routines and other code for handling pointer-related           *
* operations, including operations on strings. (character pointers)	       *
*******************************************************************************/

			/* Included for definition of NULL		      */
#include <stdio.h>

/*FLAGS************************************************************************/

/*CONSTANTS********************************************************************/

			/* Flag to perform character replacement on first     */
			/* occurence found from front of string.	      */
#define CHRREP_FRONT	0
			/* Flag to perform character replacement on first     */
			/* occurence found from end of string.		      */
#define CHRREP_REAR	1
			/* Flag to specify replacement of all occurences of   */
			/* the character in the string.			      */
#define CHRREP_ALL	2
			/* These flags are mutually exclusive.		      */

			/* Flag to denote trimming front of string	      */
#define	TRIM_FRONT	0x1
			/* Flag to denote trimming end of string	      */
#define TRIM_REAR	0x2
			/* Flag to denote trimming embedded whitespace (also  */
			/* known as compacting the string)		      */
#define TRIM_EMBED	0x4
			/* These flags can be combined.		              */
						
/*MACROS***********************************************************************/

			/*******************************************************
			* Macro to test an arbitrary pointer for equivalence   *
			* to the predefined NULL value- which implies that it  *
			* points to nothing.				       *
			********************************************************
			* p	Pointer to be tested			       *
			*******************************************************/
#define IS_NULL(p)	( (p) == NULL )

			/*******************************************************
			* Macro to test if the first element (byte) pointed to *
			* by an arbitrary pointer (usually a string) is the    *
			* null character (\0). Most useful for testing for an  *
			* empty string, but is also used to test for the end   *
			* of some forms of element lists.		       *
			********************************************************
			* p	Pointer to be tested			       *
			*******************************************************/
#define IS_EMPTY(p)	( *(p) == '\0' )

/*TYPE*DEFINITIONS*************************************************************/

/*EXTERNAL*GLOBAL*VARIABLES****************************************************/

/*EXTERNAL*ROUTINES************************************************************/

			/*******************************************************
			* Routine tests for a newline at the end of a string   *
			* and removes it if one is found. A dependant pointer  *
			* to the new string is returned.		       *
			********************************************************
			* s	String to test and edit			       *
			*******************************************************/
char *RemoveNewline(char *s);

			/*******************************************************
			* Routine to remove all whitespace specified by the    *
			* mode passed. It is capable of removing any	       *
			* combination of leading, trailing, and/or embedded    *
			* whitespace. Returns a dependant pointer to the trim  *
			* string that starts at the same location as the       *
			* passed string (along same memory boundary). This     *
			* routine does not retain the original data.	       *
			********************************************************
			* s	String to trim				       *
			*******************************************************/
char *TrimString(char *s, char mode);

			/*******************************************************
			* Routine to replace occurences of a character in a    *
			* string with another character. Mainly for changing   *
			* specified character occurences into null characters. *
			* NOTE: For parsing reasons, this routine will not     *
			* replace the null character (\0).		       *
			********************************************************
			* s		string to replace occurences in	       *
			* rep		character to replace		       *
			* repval	character to use in the replacement    *
			* mode		mode of operation for the	       *
			*		replacement(s)			       *
			*******************************************************/
char *CharReplace(char *s, char rep, char repval, char mode);

			/*******************************************************
			* Routine to allocate a new storage space the exact    *
			* size required to hold the passed string, then copies *
			* the passed string's data into it and returns its     *
			* pointer.					       *
			********************************************************
			* s	String with data to mimic		       *
			*******************************************************/
char *MimicString(char *s);
