/*******************************************************************************
* plh_memory.h								       *
********************************************************************************
* Routines pertaining to memory and its allocation.			       *
*******************************************************************************/

			/* For the exit() function call			      */
#include <stdlib.h>			
			/* For the IS_NULL macro			      */
#include <plh_ptr.h>
			/* For definition of FATALERROR			      */
#include <plh_general.h>

/*FLAGS************************************************************************/

/*CONSTANTS********************************************************************/

			/* Flag for an out of memory error		      */
#define ERR_OUT_OF_MEM	0
		
/*MACROS***********************************************************************/

			/*******************************************************
			* Macro to test the pointer to newly defined memory    *
			* and bail out of the program if the allocation failed *
			********************************************************
			* p	pointer to the newly-allocated memory	       *
			*******************************************************/
#define MemCheck(p) 	if(IS_NULL(p)) MemError(ERR_OUT_OF_MEM, FATALERROR)

/*TYPE*DEFINITIONS*************************************************************/

/*EXTERNAL*GLOBAL*VARIABLES****************************************************/

/*EXTERNAL*ROUTINES************************************************************/

			/*******************************************************
			* Routine to print the error message associated with a *
			* given error and then exit of return based on passed  *
			* classification of that error. NOTE: leaving error    *
			* class up to programmer since a program could         *
			* be intended to test out the capabilities of a        *
			* system. (runs requiring more resources until         *
			* eventual failure)				       *
			********************************************************
			* error		identifier of error that occured       *
			* class		action flag in response to error       *
			*******************************************************/
void MemError(char error, char class);
