/*******************************************************************************
* plh_io.h								       *
********************************************************************************
* Routines that have to do with reading input and writing output of programs.  *
*******************************************************************************/

			/* For definition of stdin & fgets()		      */
#include <stdio.h>
			/* For TrimString()				      */
#include <plh_ptr.h>
			/* For strlen()					      */
#include <string.h>

/*FLAGS************************************************************************/

/*CONSTANTS********************************************************************/

			/* Flag to denote that a file opening failed.	      */
#define ERR_NO_FILE	0

/*MACROS***********************************************************************/

			/*******************************************************
			* Routine to read in a string from stdin and remove    *
			* the newline if it exists. 'Returns' a dependant      *
			* pointer to the string read.			       *
			********************************************************
			* s		String to read input into	       *
			*******************************************************/
#define GetString(s)	FGetString(s, strlen(s), stdin)

			/*******************************************************
			* Macros to retrieve a string from a stdin without     *
			* leading or trailing white space. 'Returns' a	       *
			* dependant pointer to the string read.		       *
			********************************************************
			* s		String to read input into	       *
			*******************************************************/
#define GetStringClipped(s)		FGetStringClipped(s, stdin)

/*TYPE*DEFINITIONS*************************************************************/

/*EXTERNAL*GLOBAL*VARIABLES****************************************************/

/*EXTERNAL*ROUTINES************************************************************/

			/*******************************************************
			* Routine to read in a string and remove the newline   *
			* if it is read in also. It returns a dependant        *
			* pointer to the read string.			       *
			********************************************************
			* s		String to read input into	       *
			* size		maximum storage size of s              *
			* stream	input stream to read line from	       *
			*******************************************************/
char *FGetString(char *s, int size, FILE *stream);

			/*******************************************************
			* Routine to retrieve a string from a file without     *
			* any leading or trailing white space (this includes   *
			* the newline that may exist at the end). It returns a *
			* pointer to this string which is the same pointer     *
			* address that was passed to it.		       *
			********************************************************
			* s		String to read input into	       *
			* size		Maximum storage to use in the string   *
			* stream	Stream file to read input from	       *
			*******************************************************/
char *FGetStringClipped(char *s, int size, FILE *stream);
			
			/*******************************************************
			* Routine to open a required file; hence, exiting if   *
			* with an error message if the open fails. If opened   *
			* the routine returns a pointer to the file structure. *
			********************************************************
			* filename	string that contains the filename to   *
			*		open				       *
			* mode		access mode for file (fopen format)    *
			*******************************************************/
FILE *OpenOrExit(char *filename, char *mode);

			/*******************************************************
			* Routine to report that a specified error has occured *
			* and take appropriate action based on programmer      *
			* classification of the error. (usually exits)	       *
			********************************************************
			* error		Identifier of error		       *
			* class		Error classification		       *
			*******************************************************/
void IOError(char error, char class);
			
