/*
  Shambler:  Reads a list of usernames -or- UIDs,
    and logs/kills all process not found in that list

   Jay D. Allen
     Jan 1997
   $Id: shambler.c,v 1.6 1997/01/29 07:19:54 jay Exp jay $
*/

#include "shambler.h"
int mydebug=0;
int kidding=0;


void
usage(){
    printf("\nShambler - By Jay D. Allen - Jan 1997\n\n");
    printf("usage: shambler <-c config-file> [-d] [-k]\n\n");
    return;
}

main(argc, argv)
int argc;
char **argv;
{
int uid_count,index,c;
int more_opts=1;
int this_option_optind = optind ? optind : 1;
int option_index = 0;
char *config_file_name;
struct stat * mystat;
int conf_test,ret;
static char rcsid[] = "$Id: shambler.c,v 1.6 1997/01/29 07:19:54 jay Exp jay $";


/* Check the argument count */
 if (argc <= 1){
    usage();
    exit(1);
    } 

/* Read the commandline */
  while(more_opts){
  c = getopt_long (argc, argv, "c:dk", long_options, &option_index);
    if (c == -1) {
      more_opts=0;
      break;
      }
    switch(c)
       {
       case 0:
            break;
       case EOF:
         printf("EOF?\n");
         exit(1);
       case 'c':
        /*printf("config file: %s\n",optarg);*/
        (char *)config_file_name=malloc(30);
        strncpy((char *)config_file_name,optarg,(strlen(optarg)+1));
         if(mydebug){
           printf("config file: %s\n",config_file_name);
           }
        break;
       case 'd':
        printf("debug mode on\n");
        mydebug=-1;
        break;
       case 'k':
        printf("Kidding mode on\n");
        kidding=-1;
        break;
       case '?':
        usage();
        exit(1);
       case ':':
        usage();
        exit(1);
       default:
        usage();
        exit(1);
      }	
  }

/* read in the config file fill valid_uids[] with list */
conf_test=open(config_file_name,O_RDONLY);
  if ( conf_test == -1 ) {
       usage();
       exit(1);
       }
close(conf_test);

uid_count=read_config(config_file_name);
  if(uid_count == -1 ){
    printf("failed to read config\n");
    exit(1);
    }
  if(uid_count == 0){
      DEFAULT_VALID_UIDS;
      index=sizeof(valid_uids);
      printf("Empty file, so killing all but default users\n");
    }

/* now get a process list and kill at will */  
read_proc_dir((char *)PROC_DIR);
}


/* Reads the given directory and
   returns a struct with UIDs/process numbers - Not (just operate)
*/
read_proc_dir(proc_dir)
char *proc_dir;
{
char *proc[NAME_MAX+1];
char logger[80];
DIR *proc_dir_stream;
struct dirent *proc_dir_ents;
struct stat sbuf;
int pid;

openlog(SYSLOG_IDENT,LOG_NDELAY|LOG_PID,LOG_AUTHPRIV);
proc_dir_stream=opendir(proc_dir);
if (proc_dir_stream == NULL ){
    printf("failed to open proc");
    exit(1);
    }
/* open the proc directory and get a list of directory entrys */
while ((proc_dir_ents=readdir(proc_dir_stream)) != NULL ) {
   if(isdigit(proc_dir_ents->d_name[0])){
   sprintf((char *)proc,"%s/%s",proc_dir,proc_dir_ents->d_name);
   /* Stat each file */
   if((stat((char*)proc,&sbuf)) == -1) {
        printf("stat failed: %s\n",proc);
        exit(1);
        }
   if(mydebug){
     printf("%s\t\t%s\t%d\n",proc_dir_ents->d_name,proc,sbuf.st_uid); 
      }
   if(sbuf.st_uid != 500 && sbuf.st_uid != 0 && sbuf.st_uid != 99){
      pid=atoi(proc_dir_ents->d_name);
      if(! kidding){
      kill(pid,9);
       }
/*      printf("Killed: %s owned by: %d\n",proc_dir_ents->d_name,sbuf.st_uid);*/
      sprintf(logger,"Killed: %s owned by: %d",proc_dir_ents->d_name,sbuf.st_uid);
      syslog(SYSLOG_PRIORITY,logger);
      }
  }
  }
closedir(proc_dir_stream);
closelog();
}


