/*
 *  tcpscan.c -- Gate network code
 *
 *  ORIGINAL AUTHOR: Stas Lanford (stas@netsis.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "interface.h"
#include "net.h"
#include "util.h"



int scanhost(char *hostname, unsigned int lport, unsigned int hport);
int openport(char *host, int port, int hlength);
int report_scanh(int ports[], unsigned int lport, unsigned int hport, char **input);



void tcpscan(char **input) {

	int *ports;

	if ((ports = (int *)scanhost(input[0], atoi(input[1]), atoi(input[2]))) == 0) {
		quit(NULL);
	}
        if ((report_scanh((int *)ports, atoi(input[1]), atoi(input[2]), input)) < 0) {
                dialog_msgbox("Scanning", "Hmmm", 5, 35, 1);
                quit(NULL);
        	}
	dialog_clear();
        dialog_textbox(TCP_SCANRES, MAIN_LOG, 20, 60);

}    
int scanhost(char *hostname, unsigned int lport, unsigned int hport)
{

	struct hostent *host;
	int tmp;
	unsigned int ports[TCP_MAXPORT];
	host = gethostbyname(hostname);
	
	tmp=--lport;

/* Avoid for() 4now */

	while (tmp<=hport) {
		ports[tmp] = openport(host->h_addr_list[0], tmp, host->h_length);
/*		printf("-%d:%d-\n", tmp, ports[tmp]); */
		tmp++;
	}
	return (int *)ports;
}

int openport(char *host, int port, int hlength) {

	int sock, re;
	struct sockaddr_in tmp;
	bzero(&tmp, sizeof(struct sockaddr_in));
	sock = socket(AF_INET,  SOCK_STREAM, 6);
	tmp.sin_family = AF_INET;
	tmp.sin_port = htons(port);
	bcopy(host, &tmp.sin_addr.s_addr, hlength);
	if ((re = connect(sock, (struct sockaddr *)&tmp, sizeof(struct sockaddr_in))) < 0) {

#ifdef DEBUG
		fprintf(stderr, "%d. ", ntohs(tmp.sin_port));
		perror("con"); 
#endif
	}
	else {
#ifdef DEBUG
	fprintf(stderr, "%d. Open\n", ntohs(tmp.sin_port));  
#endif
	}
	close(sock);
	return re;
}


int report_scanh(int ports[], unsigned int lport, unsigned int hport, char **input) {

int tmp;
FILE *scanh;

	scanh = openlog();


        for(tmp = lport; tmp <= hport; tmp++) {
                if (ports[tmp] == 0) {
                        fprintf(scanh, "%s.[%d] ---> Open\n",
                                input[0], tmp);
                }
                if(ports[tmp] == -1) {
                        fprintf(scanh, "%s.[%d] ---> Closed.\n",
                                input[0], tmp);
                }
        }
        fclose(scanh);
        return 0;
}

