/*
 *  nfsscan.c -- Gate network code
 *
 *  NETWORK STUFF: Berkeley people
 *  EVERYTHING ELSE: Stas Lanford (stas@netsis.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "interface.h"
#include "net.h"
#include "util.h"



static int type = 0;

int xdr_exports (XDR *, struct exportslist **);
int tcp_callrpc (char *host,
                     int prognum, int versnum, int procnum,
                     xdrproc_t inproc, char *in,
                     xdrproc_t outproc, char *out);




int nfsscan (char **iprange)
{
	register int mntvers=1; 
	FILE *log;
	unsigned int index;

	log = openlog();


     for (index=0; iprange[index]!=NULL; index++) {

		struct exportslist *exp;
		struct exportslist *exports;
		struct grouplist *grp;

               	if (tcp_callrpc(iprange[index], RPCPROG_MNT, mntvers,
               		RPCMNT_EXPORT, xdr_void, (char *)0,
                       	xdr_exports, (char *)&exports) != 0) {
			fprintf(log, "%s: Unable to retrieve.\n", iprange[index]);
               	} else {
               		fprintf(log, "%s: Exports list:\n", iprange[index]);
               		exp = exports;
               		while (exp) {
                       		fprintf(log, "%s\t", exp->ex_dirp);
                       		grp = exp->ex_groups;
                       		if (grp == NULL) {
                               		fprintf(log, "Everyone!\n");
                       		} else {
                               		while (grp) {
                                       		fprintf(log, "%s ", grp->gr_name);
                                       		grp = grp->gr_next;
                               		}
                               	fprintf(log, "\n\n");
                       		}
                       	exp = exp->ex_next;
			}
		}	
		fprintf(log,"\n");
	}
	fclose(log);
	dialog_clear(); 
	dialog_textbox(NFS_SCANRES, MAIN_LOG, 20, 70); 


	return 0;
}

 
int
tcp_callrpc(host, prognum, versnum, procnum, inproc, in, outproc, out)
        char *host;
        int prognum;
        int versnum;
        xdrproc_t inproc;
        char *in;
        xdrproc_t outproc;
        char *out;
{
        struct hostent *hp;
        struct sockaddr_in server_addr;
        CLIENT *client;
        int sock;
        struct timeval timeout;
        int rval;
	u_long addr;
        
	(int)addr = inet_addr(host);
        hp = gethostbyaddr((char *)&addr, sizeof(addr), AF_INET);
 
        if (!hp)
                return ((int) RPC_UNKNOWNHOST);
 
        memset(&server_addr,0,sizeof(server_addr));
        memcpy((char *) &server_addr.sin_addr,
               hp->h_addr,
               hp->h_length);
   /*     server_addr.sin_len = sizeof(struct sockaddr_in);
*/
        server_addr.sin_family =AF_INET;
        server_addr.sin_port = 0;
                 
        sock = RPC_ANYSOCK;
                 
        client = clnttcp_create(&server_addr,
                                (u_long) prognum,
                                (u_long) versnum, &sock, 0, 0);
        if (!client) {
                timeout.tv_sec = 5;
                timeout.tv_usec = 0;
                server_addr.sin_port = 0;
                sock = RPC_ANYSOCK;
                client = clntudp_create(&server_addr,
                                        (u_long) prognum,
                                        (u_long) versnum,
                                        timeout,
                                        &sock);
        }
        if (!client)
                return ((int) rpc_createerr.cf_stat);
 
        timeout.tv_sec = 25;
        timeout.tv_usec = 0;
        rval = (int) clnt_call(client, procnum,
                               inproc, in,
                               outproc, out,
                               timeout);
        clnt_destroy(client);
        return rval;
}
 

/*
 * Xdr routine to retrieve exports list
 */
int
xdr_exports(xdrsp, exp)
	XDR *xdrsp;
	struct exportslist **exp;
{
	register struct exportslist *ep;
	register struct grouplist *gp;
	int bool, grpbool;
	char *strp;

	*exp = (struct exportslist *)0;
	if (!xdr_bool(xdrsp, &bool))
		return (0);
	while (bool) {
		ep = (struct exportslist *)malloc(sizeof(struct exportslist));
		if (ep == NULL)
			return (0);
		ep->ex_groups = (struct grouplist *)0;
		strp = ep->ex_dirp;
		if (!xdr_string(xdrsp, &strp, RPCMNT_PATHLEN))
			return (0);
		if (!xdr_bool(xdrsp, &grpbool))
			return (0);
		while (grpbool) {
			gp = (struct grouplist *)malloc(sizeof(struct grouplist));
			if (gp == NULL)
				return (0);
			strp = gp->gr_name;
			if (!xdr_string(xdrsp, &strp, RPCMNT_NAMELEN))
				return (0);
			gp->gr_next = ep->ex_groups;
			ep->ex_groups = gp;
			if (!xdr_bool(xdrsp, &grpbool))
				return (0);
		}
		ep->ex_next = *exp;
		*exp = ep;
		if (!xdr_bool(xdrsp, &bool))
			return (0);
	}
	return (1);
}


/*
 * Print the binary tree in inorder so that output is sorted.
 */
void
print_dump(mp)
	struct mountlist *mp;
{

	if (mp == NULL)
		return;
	if (mp->ml_left)
		print_dump(mp->ml_left);
	switch (type) {
	case NFS_ALL:
		printf("%s:%s\n", mp->ml_host, mp->ml_dirp);
		break;
	case NFS_DIRS:
		printf("%s\n", mp->ml_dirp);
		break;
	default:
		printf("%s\n", mp->ml_host);
		break;
	};
	if (mp->ml_right)
		print_dump(mp->ml_right);
}

