/*
 *  lowrisk.c -- Gate network code
 *
 *  ORIGINAL AUTHOR: Stas Lanford (stas@netsis.co)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#include "net.h"
#include "util.h"
#include "interface.h"




void check_netstat (char **iprange) 
{

	unsigned int index, sockfd;
	FILE *log;


	log = openlog();

	for (index=0; iprange[index]!=NULL; index++) {
		if (set_connect(iprange[index], NETSTAT_PORT,&sockfd) == 0) {
			fprintf(log, "%s: Nestat service available.\n", iprange[index]);
		}
		else { fprintf(log, "%s: Netstat connection refused.\n", iprange[index]);
		}
		close(sockfd);
	}
	fclose(log);
	close(sockfd);
}


void low_scan(char **iprange) 
{

	check_netstat(iprange);
	dialog_clear();
	dialog_textbox(IP_SCANRES, MAIN_LOG, 20, 60);
}

		

	
