/*
 *  gate.c -- Gate main()
 *  See README
 *
 *  ORIGINAL AUTHOR: Stas Lanford (stas@netsis.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */




#include "net.h"
#include "interface.h"
#include "util.h"


#define NAME    "Gate"
#define VER     "Beta 1"
#define OS      "Linux"
#define MAINARGS "General Variable(s)"
#define MAINMSG	 "Enter IP range/Hostname & Ports"



unsigned int port_query[];
char *scan_ports;


char name[100];
void main()
{
	char **args; 
	char *tmptitle;
	int count;
	char **iprange;
	char *input;

	system("reset");

	if (getuid() && geteuid() != 0) {
		fprintf(stderr, "----------------------\n");
		fprintf(stderr, "Gate execution failed.\n");
		fprintf(stderr, "Root access required.\n");
		fprintf(stderr, "-----------------------\n");
		exit(1);
	} 


	if ((tmptitle = malloc(50)) == NULL) {
                fprintf(stderr,"Interface memory allocation failure\n.");
                exit(1);
        }
	sprintf(tmptitle, "%s %s for %s ", NAME, VER, OS);
	backtitle = tmptitle;



    	init_dialog ();

	dialog_msgbox ("Tishina Presents", "Gate Security.\nhttp://tishina.home.ml.org.\nNo rights reserved.", 7, 31, 0);

        if ((args = malloc(4000)) == NULL) {
                fprintf(stderr,"Interface memory allocation failure.\n");
                exit(1);
        }
        count = (int)init_mmenu(args);
	sleep(1);

	if ((agree ()) < 0) { 
		
		quit(args); } 
	do {
		if (askargs("HOLA", MAINMSG)==911) {
		}
		input = dialog_input_result;
		iprange=  parsemain(input);
	} while (iprange == 1);


	writehead();

	while (1) { 
    		mmenu (NAME, count, (char **)args);
		if (check_result[1] == '1') {
			errmsg("Scanning ports..."); 
			tcpscan(iprange);
		}
		if (check_result[1] == '2') {
			errmsg("Resolving hosts...");
			ipscan(iprange);
		}
		if (check_result[1] == '3') {
			errmsg("Scanning NFS...");
			nfsscan(iprange);
		}
		if (check_result[1] == '4') {
			errmsg("Scanning finger...");
			finscan(iprange);
		}
		if (check_result[1] == '5') {
			errmsg("Scanning low services...");
			low_scan(iprange);
		}
		if (check_result[1] == '6') {
			errmsg("Scanning web...");
			web_scan(iprange);
		}
	}		

    	end_dialog();
	quit(args);
}

short init_mmenu(char **args) {
	
	short count;
	
	args[2] = "Choose the function.";
	args[3] = "20";
	args[4] = "40";
	args[5] = "10";
	args[6] = "11";
	args[7] = "TCP Host Scan";
	args[8] = "0";
	args[9] = "22";
	args[10]= "IP Resolution";
	args[11]= "0";
	args[12] = "33";
	args[13]= "NFS Scan";
	args[14]= "0";
	args[15]= "44";
	args[16]= "Finger Scan";
	args[17]= "0";
	args[18]= "66";
	args[19]= "WWW Scan.";
	args[20]= "0";
	args[21]= "55";
	args[22]= "Lowrisk Scan";
	args[23]= "0";
	args[24]= "911";	/* Last one should always be '911' */

	for (count=0; args[count] != "911"; count++) { 
 	}
		

#ifdef DEBUG 
	for (n=0; args[n]!=NULL; n++) {
		printf("args[%d]. ---> %s\n", n, args[n]);
	}
#endif

	return count++;
}



void nihilo() { system("reset"); }






