
/* net.h */
/* Gate network header. */



#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include <netdb.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <arpa/inet.h>

#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>
#include <rpc/pmap_prot.h>
#include "rpcv2.h"


#define NETERROR3       "Warning!"
#define NETERROR2	"Caution!"
#define NETERROR1	"Attention!"

#define TCP_MAXPORT         60000
#define TCP_LOG          "tcpscan.log"
#define TCP_SCANRES         "Host Scan Results"
#define TCP_RESY            30
#define TCP_RESX            15

#define IP_LOG           "ips.log"
#define IP_SCANRES         "Network IP Scan Results"
#define IP_RESX		  30
#define IP_RESY		  30

#define NFS_ALL     	1
#define NFS_DIRS    	2
#define RPC_PORT 	111
#define NFS_ALARM	3
#define NFS_LOG 	"export.log"
#define NFS_SCANRES 	"Exported Filesystems"
#define NFS_RESY	27
#define NFS_RESX	40

#define FIN_NEEDLE1	"not allowed"
#define FIN_NEEDLE2	"uid"
#define FIN_NEEDLE3	"root"
#define FIN_FAIL	"unknown"
#define FIN_LOG		"fin.log"

#define NETSTAT_PORT	15
#define LOWRISK_LOG	"lowrisk.log"

#define PHF_BUG		"GET /cgi-bin/phf?Qalias=%0a/bin/id"
#define PHF_NEEDLE	"uid"
#define WEB_LOG		"webscan.log"
#define HTTPD_PORT	80





struct ips {

        unsigned int p[14];
};

struct ipstr {
        char st[15];
        char sa[15];
        char temp[15];
};


struct tcp_scan {
        char host[100];
        char sport[7];
        char dport[7];
};


struct mountlist {
        struct mountlist *ml_left;
        struct mountlist *ml_right;
        char    ml_host[RPCMNT_NAMELEN+1];
        char    ml_dirp[RPCMNT_PATHLEN+1];
};

struct grouplist {
        struct grouplist *gr_next;
        char    gr_name[RPCMNT_NAMELEN+1];
};

struct exportslist {
        struct exportslist *ex_next;
        struct grouplist *ex_groups;
        char    ex_dirp[RPCMNT_PATHLEN+1];
};



char *checkhost(char *host); 
char *hostname(void);

void tcpscan(char **input);
void ipscan(char **iprange);
int nfsscan(char **iprange);
void low_scan(char **iprange);

 
