#include <sys/param.h>
#include <sys/stat.h>

#include <ctype.h>
#include <errno.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


/* #define BUF_SIZE	600000 */
#define F_SIZE	fsize(ldif)
#define N_SIZE  50
#define PHONE_SIZE 20 
#define ENT_SIZE 22
#define ENTRIES ldif_count(entries) 
#define NEEDLE	"server: 0"
#define CSV_ENTRIES csv_count(buffer)
#define FIELDS	21
#define LSTRINGS 15


struct ldif_entry {

	char lastname[N_SIZE];
	char firstname[N_SIZE];
	char title[N_SIZE];
	char company[N_SIZE];
	char work[PHONE_SIZE];
	char home[PHONE_SIZE];
	char fax[PHONE_SIZE];
	char email[N_SIZE];
	char address[N_SIZE];
	char city[N_SIZE];
	char state[2];
	char zip[PHONE_SIZE];
	char country[N_SIZE];
	char note[N_SIZE*N_SIZE*N_SIZE];
};


char *lstrings[] = {
	"sn",
	"givenname",
	"title",
	"o:",			/* ':' needed to find this line */
	"telephonenumber",
	"homephone",
	"facsimiletelephonenumber",
	"mai",			/* 'l' missing on purpose */
	"postOfficeBox",
	"locality",
	"st",
	"postalcode",
	"countryname",
	"description",
	NULL };


long fsize(FILE *);
int bflag, eflag, nflag, sflag, tflag, vflag;
char *filename;



int csv_count(char *buffer) {

	unsigned int index, count=0;
	for (index=0; buffer[index]!='\0'; index++) {
			if (buffer[index]=='\n' && buffer[++index]=='"') { count++; }
	}
	return count;
}


int ldif_count(char *buffer) {

	unsigned int index, count=0;
	for (index=0; buffer[index]!='\0'; index++) {
			if (buffer[index]=='v' && buffer[++index]=='e' && buffer[++index]=='r') { count++; }
	}
	return count;
}


long fsize(FILE *ldif) {

	fseek(ldif, 0L, SEEK_SET);
	fseek(ldif, 0L, SEEK_END);
	return (ftell(ldif));
}

void usage(char *argv) {
	fprintf(stderr, "\nUsage: %s <source file> <destination file>\n", argv);
}



char *
f_read(fp, base)
	register FILE *fp;
	char *base;
{
	register int ch, gobble, line, prev, a=0;

	line = gobble = 0;
	for (prev = '\n'; (ch = getc(fp)) != EOF; prev = ch) {
		base[a++]=ch;
		if (prev == '\n') {
			if (ch == '\n') {
				if (sflag) {
					if (!gobble && putchar(ch) == EOF)
						break;
					gobble = 1;
					continue;
				}
				if (nflag && !bflag) {
					(void)fprintf(stdout, "%6d\t", ++line);
					if (ferror(stdout))
						break;
				}
			} else if (nflag) {
				(void)fprintf(stdout, "%6d\t", ++line);
				if (ferror(stdout))
					break;
			}
		}
		gobble = 0;
		if (ch == '\n') {
			if (eflag)
				if (putchar('$') == EOF)
					break;
		} else if (ch == '\t') {
			if (tflag) {
				if (putchar('^') == EOF || putchar('I') == EOF)
					break;
				continue;
			}
		} else if (vflag) {
			if (!isascii(ch)) {
				if (putchar('M') == EOF || putchar('-') == EOF)
					break;
				ch = toascii(ch);
			}
			if (iscntrl(ch)) {
				if (putchar('^') == EOF ||
				    putchar(ch == '\177' ? '?' :
				    ch | 0100) == EOF)
					break;
				continue;
			}
		}
		if (putchar(ch) == EOF)
			break;
	}
	if (ferror(fp)) {
		perror("cook_buf");
		clearerr(fp);
	}
	if (ferror(stdout))
		perror("aie");
}


void
raw_cat(rfd)
	register int rfd;
{
	register int nr, nw, off, wfd;
	static int bsize;
	static char *buf;
	struct stat sbuf;

	wfd = fileno(stdout);
	if (buf == NULL) {
		if (fstat(wfd, &sbuf))
			perror("raw_cat");
		bsize = 10000;
		if ((buf = malloc((u_int)bsize)) == NULL)
			perror("malloc");
	}
	while ((nr = read(rfd, buf, bsize)) > 0)
		for (off = 0; nr; nr -= nw, off += nw)
			if ((nw = write(wfd, buf + off, nr)) < 0)
			perror("raw_cat");

	if (nr < 0)
			perror("raw_cat");
}

