#include <config.h>
#include "basic.h"
#include "n_errno.h"
#include "log.h"
#include "mem.h"

/* Create a new memory structure */

MemBlock *mem_create(size_t size)
{      
   MemBlock *memblock;   
   void *pnt;
   
   if (size == 0) {
      size = MEM_CHUNKSIZE;
   }
#ifdef MALLOC_NEEDS_A_MINIMUM
   if (size < MALLOC_NEEDS_A_MINIMUM) {
      size += (size_t) MALLOC_NEEDS_A_MINIMUM;
   }
   {
      size_t psize = (sizeof *memblock);
      
      if (psize < (size_t) MALLOC_NEEDS_A_MINIMUM) {
	 psize = (size_t) MALLOC_NEEDS_A_MINIMUM;
      }
      if ((memblock = (MemBlock *) malloc(psize) == NULL) {
	 log_log(LOG_ERR, NULL, _("Chunk container allocation"));      	 
	 return NULL;
      }
   }
#else
   if ((memblock = (MemBlock *) malloc(sizeof *memblock)) == NULL) {
      log_log(LOG_ERR, NULL, _("Chunk container allocation"));      
      return NULL;
   }
#endif
   memblock->requests = 0;   
   if ((pnt = (void *) malloc(size)) == NULL) {
      log_log(LOG_ERR, NULL, _("Dynamic memory allocation"));
      free(memblock);
      
      return NULL;
   } else {
      memblock->space = pnt;
      memblock->size = size;
   }
      
   return memblock;
}
   
/* Fit the block to store <size> bytes */
   
int mem_resize(MemBlock * const pnt, size_t size)
{
   if (size > pnt->size) {
      pnt->size = size + MEM_CHUNKSIZE;	     
#if MEM_SHRINK
      changeit:
#endif
      pnt->requests = 0;
      if ((pnt->space = (void *) realloc(pnt->space, pnt->size)) == NULL) {
	 log_log(LOG_ERR, NULL, _("Memory reallocation"));
	 return -1;
      }
   } 
#if MEM_SHRINK
   else if (size < pnt->size) {
      pnt->requests++;
      if (pnt->requests == MEM_SHRINKREQUESTS) {
	 pnt->size -= (((pnt->size - size) >> 1) - 1);
	 goto changeit;
      }
   }
#endif
   
   return 0;
}

/* Free a memory byte */
   
int mem_free(MemBlock * const pnt)
{
   if (pnt == NULL) {
      return -1;
   }
   if (pnt->space != NULL && pnt->size != 0) {
      free(pnt->space);
   }
   free(pnt);
   
   return 0;
}


