#include <config.h>
#include "basic.h"
#include "n_errno.h"
#include "n_file.h"
#include "log.h"

static unsigned char log_isopen;

int log_opensyslog(const char * const name, const int facility)
{
#ifdef HAVE_SYSLOG
   if (log_isopen != 0) {
      return -1;
   }   
   openlog(name, LOG_NDELAY | LOG_NOWAIT, facility);
   log_isopen = 1;
#endif
   
   return 0;
}

int log_closesyslog(void)
{
#ifdef HAVE_SYSLOG
   if (log_isopen == 0) {
      return -1;
   }
   closelog();
   log_isopen = 0;
#endif
   
   return 0;
}

int log_writesyslog(const int priority, const char * const what)
{
#ifdef HAVE_SYSLOG
   if (log_isopen == 0) {
      return -1;
   }
   syslog(priority, what);
#endif
   
   return 0;
}

char *log_vprintf(const char *format, va_list args)
{
   static unsigned char buf[LOG_VMAXSTRINGLEN + LOG_VCENSOREDLEN + 1];
   static char vtmpdigitbuf[LOG_VTMPDIGITBUFLEN];   
   register unsigned char *bufpnt = buf;
   register const unsigned char *fmtpnt = (const unsigned char *) format;
   const unsigned char *arg;
   size_t t = LOG_VMAXSTRINGLEN;
   unsigned char c;
   
   for (;;) {
      brekout:      
      if ((c = *fmtpnt) == 0) {
	 break;
      }
      fmtpnt++;
      if (c == (unsigned char) '%') {
	 if ((c = *fmtpnt) == 0) {
	    break;
	 }
	 fmtpnt++;
	 if (c == (unsigned char) '%') {
	    *bufpnt++ = (unsigned char) '%';
	    saxo:
	    t--;
	    if (t == 0) {
	       break;
	    }	    
	 } else if (c == (unsigned char) 's') {	    	    
	    const unsigned char *censor;
	    size_t s;
	    size_t censorlen;
	    size_t t2;
	    
	    arg = va_arg(args, const unsigned char *);
	    
	    proceed:
	    censorlen = LOG_VCENSOREDLEN;
	    t2 = LOG_VMAXARGLEFTLEN;
	    censor = (const unsigned char *) LOG_CENSORED;	    
	    
	    if (arg == NULL) {
	       arg = (const unsigned char *) "(?)";
	    }
	    s = strlen((const char *) arg);
	    do {
	       *bufpnt++ = *arg++;
	       t--; if (t == 0) {
		  goto brekin;
	       }
	       s--; if (s == 0) {
		  goto brekout;
	       }
	       t2--;
	    } while (t2 != 0);
	    if (s > (LOG_VMAXARGRIGHTLEN + LOG_VCENSOREDLEN)) {
	       do {
		  *bufpnt++ = *censor++;
		  t--; if (t == 0) {
		     goto brekin;
		  }
		  censorlen--;
	       } while (censorlen != 0);
	    }
	    t2 = LOG_VMAXARGRIGHTLEN;
	    if (s > LOG_VMAXARGRIGHTLEN) {
	       arg += s - LOG_VMAXARGRIGHTLEN;
	    }
	    do {
	       *bufpnt++ = *arg++;
	       t--; if (t == 0) {
		  goto brekin;
	       }
	       s--; if (s == 0) {
		  goto brekout;
	       }
	       t2--;
	    } while (t2 != 0);
	 } else if (c == (unsigned char) 'd') {
	    sprintf(vtmpdigitbuf, "%d", va_arg(args, int));
	    arg = (const unsigned char *) vtmpdigitbuf;
	    goto proceed;
	 } else if (c == (unsigned char) 'u') {
	    sprintf(vtmpdigitbuf, "%u", va_arg(args, unsigned int));
	    arg = (const unsigned char *) vtmpdigitbuf;
	    goto proceed;
	 } else if (c == (unsigned char) 'p') {
	    sprintf(vtmpdigitbuf, "%p", va_arg(args, void *));
	    arg = (const unsigned char *) vtmpdigitbuf;
	    goto proceed;
	 } else if (c == (unsigned char) 'f') {
	    sprintf(vtmpdigitbuf, "%f", va_arg(args, double));
	    arg = (const unsigned char *) vtmpdigitbuf;
	    goto proceed;
	 }
      } else if (isalnum((int) c) || ispunct((int) c)) {
	 *bufpnt++ = c;	 
	 goto saxo;
      } else if (isspace((int) c)) {
	 *bufpnt++ = (unsigned char) ' ';
	 goto saxo;
      } else {
	 *bufpnt++ = (unsigned char) '_';
	 goto saxo;
      }
   }
   brekin:
   if (c != 0) {
      const unsigned char *censor = (const unsigned char *) LOG_CENSORED;
      size_t censorlen = LOG_VCENSOREDLEN;
      
      do {	 
	 *bufpnt++ = *censor++;
	 censorlen--;
      } while (censorlen != 0);
   }
   *bufpnt = 0;   
   
   return (char *) buf;
}

char *log_sprintf(const char *format, ...)
{
   char *ret;
   va_list args;
   
   va_start(args, format);
   ret = log_vprintf(format, args);
   va_end(args);
   
   return ret;
}

int log_log(const int priority, const char * const file,
	     const char * format, ...)
{
   char *str;
   va_list args;
   
   va_start(args, format);
   
#ifndef DEBUG
   if (priority == LOG_DEBUG) {
      return 0;
   }
#endif
   
   if ((str = log_vprintf(format, args)) == NULL) {
      greez:
      va_end(args);
      return -1;
   }
   if (file == NULL) {
#ifdef HAVE_SYSLOG
      log_writesyslog(priority, str);
# ifdef DEBUG
      if (priority == LOG_DEBUG) {
	 fputs(str, stderr);
	 fputc('\n', stderr);
      }
# endif
      if (priority == LOG_ERR) {
	 fputs(str, stderr);
	 fputc('\n', stderr);
      }
#else
      fputs(str, stderr);
      fputc('\n', stderr);
#endif
   } else {
      FILE *fp;
      
      if ((fp = fopen(str, "at")) == NULL) {
	 goto greez;
      }
      fputs(str, fp);
      fputc('\n', fp);
      fclose(fp);
   }

   va_end(args);
     
   return 0;
}
