
/* (C)oderight 1997 by Jedi/Sector One */

#ifndef INCLUDED_SOCKETLIB
#define INCLUDED_SOCKETLIB

#include "socket.h"

#ifndef SOCKLINE_MAX
# define SOCKLINE_MAX 32768U
# if CONF_TCP_SO_RCVBUF > SOCKLINE_MAX
#  undef SOCKLINE_MAX
#  define SOCKLINE_MAX CONF_TCP_SO_RCVBUF
# endif
# if CONF_TCP_SO_SNDBUF > SOCKLINE_MAX
#  undef SOCKLINE_MAX
#  define SOCKLINE_MAX CONF_TCP_SO_SNDBUF
# endif
# if CONF_UDP_SO_RCVBUF > SOCKLINE_MAX
#  undef SOCKLINE_MAX
#  define SOCKLINE_MAX CONF_UDP_SO_RCVBUF
# endif
# if CONF_UDP_SO_SNDBUF > SOCKLINE_MAX
#  undef SOCKLINE_MAX
#  define SOCKLINE_MAX CONF_UDP_SO_SNDBUF
# endif
#endif

#define SOCKMAX_FD CONF_MAXFD
#ifdef _POSIX_OPEN_MAX
# if _POSIX_OPEN_MAX > SOCKMAX_FD
#  undef SOCKMAX_FD
#  define SOCKMAX_FD _POSIX_OPEN_MAX
# endif
#endif

#define SOCKETLIB_MAJORVERSION 0
#define SOCKETLIB_MINORVERSION 6

typedef enum {
   SOCKEVENT_NONE,
   SOCKEVENT_ERROR,
   SOCKEVENT_PEERRESET,
   SOCKEVENT_TOOMANY,
   SOCKEVENT_NEWCNX,
   SOCKEVENT_ANSWER,
   SOCKEVENT_HANGUP,
   SOCKEVENT_INTERRUPTED
} SockEventType;

typedef enum {
   SOCKET_OPTION_NONE = 0,
   SOCKET_OPTION_RR = 1,
   SOCKET_OPTION_RA = SOCKET_OPTION_RR << 1,
   SOCKET_OPTION_TS = SOCKET_OPTION_RA << 1,
   SOCKET_OPTION_SATID = SOCKET_OPTION_TS << 1,
   SOCKET_OPTION_SSRR = SOCKET_OPTION_SATID << 1,
   SOCKET_OPTION_LSRR = SOCKET_OPTION_SSRR << 1,
   SOCKET_OPTION_SECURITY = SOCKET_OPTION_LSRR << 1     
} SocketOptions;

typedef struct SockEvent_ {
   SockEventType type;
   int fd;
   unsigned char fdoverflow;   
   size_t linelen;
   char line[SOCKLINE_MAX + 1];
   unsigned char remotecnx[SOCKMAX_FD + 1];
   SocketOptions options;
   struct Socket_ * socket;
} SockEvent;

typedef enum {
   SOCKET_OPTION_DEFAULT = 2,
   SOCKET_OPTION_ON = 1,
   SOCKET_OPTION_OFF = 0
} SocketOptionFlag;

typedef struct Socket_ {
   struct Sockets_ *sockets;
   int fd;
   int port;
   SocketOptionFlag optionnodelay;
   SocketOptionFlag optionkeepalive;
   int endpoint;
   unsigned long cookie, cookie2;
   void *geek, *geek2;
#ifdef IPV6_SUPPORT
   struct sockaddr_in6 addr;
#else
   struct sockaddr_in addr;
#endif
} Socket;

typedef struct SocketListItem_ {
   Socket *socket;
   struct SocketListItem_ *next;
} SocketListItem;

typedef struct Sockets_ {
   int first;
   fd_set lastrfds;
   fd_set rfdsbackup;
   int lastfd;   
   int pendingmessages;
   int pendingsync;
   SocketListItem *socketlist;
   SocketListItem *listlastitem;
   Socket *fdtosocket[SOCKMAX_FD + 1];
   SockEvent sockevent;
   unsigned long cookie, cookie2;
   void *geek, *geek2;
} Sockets;

enum {
   SOCKET_BACKLOG = 20,
   SOCKET_PENDINGSYNC = 17
};

enum {
   SOCKET_MINUSERPORT = 1024,
};

enum {
   SOCKET_MAXHOSTALIASES = 1024,
   SOCKET_MAXHOSTIPS = 1024
};

Socket * socket_clientcreate(Sockets * const sockets,
			     const char * const hostname, 
			     const char * const hostnameenv,
			     const char * const endpoint,
			     const char * const protocol,
			     const char * const portname, unsigned short port);

Socket * socket_servercreate(Sockets * const sockets,
			     const char * const hostname,
			     const char * const hostnameenv,
			     const char * const endpoint,
			     const char * const protocol,
			     const char * const portname, unsigned short port);

int socket_clientclose(Socket * const socket);
int socket_serverclose(Socket * const socket);
int socket_hangup(Socket * const socket, const int fd);
int socket_print(const int fd, const char * const str);
char *socket_read(const int fd);
int socket_flush(const int fd);
int socket_servercnxwait(Socket * const socket);
SockEvent *socket_serverwaitevent(Sockets * const sockets);
int socket_optionnodelay(Socket * const socket, const SocketOptionFlag on);
int socket_optionkeepalive(Socket * const socket, const SocketOptionFlag on);
int socket_fdlisten(Sockets * const sockets, const int fd);
int socket_fdunlisten(Sockets * const sockets, const int fd);
int socket_isstream(const Socket * const socket);
int socket_isipv6(const int fd);
int socket_initsockets(Sockets * const sockets);
int socket_closeall(Sockets * const sockets);
const char *socket_getpeeraddr(Socket * const socket, const int fd);
const char **socket_getpeername(Socket * const socket, const int fd);
const char *socket_getpeernameoraddr(Socket * const socket, const int fd);

int fd_move(const int to, const int from);
int fd_copy(const int to, const int from);

size_t maxhostnamelen(void);

#endif
