
/* (C)oderite Jedi/Sector One */

#ifndef INCLUDED_NEWERRNO
#define INCLUDED_NEWERRNO

#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif

#ifndef HAVE_STRERROR
# ifdef NEED_SYS_ERRLIST
extern char *sys_errlist[];
# endif
#endif

#ifndef EXIT_SUCCESS
enum { EXIT_SUCCESS = 0 };
#endif
#ifndef EXIT_FAILURE
enum { EXIT_FAILURE = 1 };
#endif

#if defined (__VMS__) || defined (VMS)
# define EXIT(ERR) exit(ERR == 0 ? EXIT_SUCCESS : EXIT_FAILURE)
#else
# define EXIT(ERR) exit(ERR == 0 ? EXIT_SUCCESS : ERR)
#endif

#ifdef __GNUC__
# define HAVE_PRETTY_FUNCTION
#endif

#ifdef HAVE_PRETTY_FUNCTION
# define TRACE tracerr(__FILE__, __LINE__, __PRETTY_FUNCTION__)
# define PRINTWARNING(MORE) printerr(MORE, __FILE__, __LINE__, __PRETTY_FUNCTION__)
#else
# define TRACE tracerr(__FILE__, __LINE__)
# define PRINTWARNING(MORE) printerr(MORE, __FILE__, __LINE__)
#endif

#define PRINTDEBUG(MORE) PRINTWARNING(MORE)
#define PRINTERROR(MORE) PRINTWARNING(MORE); EXIT(ERR)

extern void tracerr(const char * const file, const int line
#ifdef HAVE_PRETTY_FUNCTION
		    , const char * const function
#endif
		  );

extern void printerr(const char * const more,
		     const char * const file, const int line
#ifdef HAVE_PRETTY_FUNCTION
		     , const char * const function
#endif
		     );

#endif

extern char *newstrerror(const int err);
