
/* (C)oderite 1997 by Jedi/Sector One <fdenis@industrie.capgemini.fr> */

#ifndef INCLUDED_LOG
#define INCLUDED_LOG

#include <stdarg.h>
#ifdef HAVE_SYSLOG_H
# include <syslog.h>
#elif defined (HAVE_SYS_SYSLOG_H)
# include <sys/syslog.h>
#elif !defined (HAVE_SYSLOG)
enum {
   LOG_NDELAY, LOG_NOWAIT, LOG_DAEMON,
   LOG_NOTICE, LOG_DEBUG, LOG_ERR, LOG_WARNING, LOG_INFO
};
#endif

#if defined (_WIN32) && defined (HAVE_SYSLOG)
# undef HAVE_SYSLOG
#endif

int log_opensyslog(const char * const name, const int facility);
int log_closesyslog(void);
int log_writesyslog(const int priority, const char * const what);
char *log_vprintf(const char *format, va_list args);
char *log_sprintf(const char *format, ...);
int log_log(const int priority, const char * const file,	   
	    const char * format, ...);


#define LOG_CENSORED "..."

enum {
   LOG_VMAXARGLEFTLEN = 32,
   LOG_VMAXARGRIGHTLEN = 32,
   LOG_VCENSOREDLEN = (sizeof LOG_CENSORED) - 1,
   LOG_VMAXARGLEN = LOG_VMAXARGLEFTLEN + LOG_VMAXARGRIGHTLEN + LOG_VCENSOREDLEN,
   LOG_VMAXSTRINGLEN = 256,
   LOG_VTMPDIGITBUFLEN = LINE_MAX
};

#define LOG_ERRMARK(A, B) TRACE; log_log(LOG_ERR, A, B " <%s>", newstrerror(errno))

#endif
