/*
 * @(#)Object.java	1.25 95/08/18  
 *
 * Copyright (c) 1994 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

package java.lang;

/**
 * The root of the Class hierarchy.  Every Class in the system
 * has Object as its ultimate parent.  Every variable and method
 * defined here is available in every Object. 
 * @see		Class
 * @version 	1.25, 08/18/95
 */
public class Object {
    /**
     * Returns the Class of this Object. Java has a runtime
     * representation for classes- a descriptor of type Class- 
     * which the method getClass() returns for any Object.
     */
    public final native Class getClass();

    /**
     * Returns a hashcode for this Object.
     * Each Object in the Java system has a hashcode. The hashcode
     * is a number that is usually different for different Objects.
     * It is used when storing Objects in hashtables.
     * Note: hashcodes can be negative as well as positive.
     * @see		java.util.Hashtable
     */
    public native int hashCode();

    /**
     * Compares two Objects for equality.
     * Returns a boolean that indicates whether this Object is equivalent 
     * to the specified Object. This method is used when an Object is stored
     * in a hashtable.
     * @param	obj	the Object to compare with
     * @return	true if these Objects are equal; false otherwise.
     * @see		java.util.Hashtable
     */
    public boolean equals(Object obj) {
	return (this == obj);
    }

    /**
     * Copies the contents of the specified Object into this Object.  The contents
     * of an Object are defined as the values of its instance variables.  The 
     * parameter src must be of the same Class as this Object.
     * @param src the Object whose contents are copied into the current object
     * @exception	ClassCastException If obj is not of the same type as
     *			this Object.
     * @see		Object#clone
     */
    protected native void copy(Object src);

    /**
     * Creates a clone of this Object. A new instance is allocated and
     * the copy() method is called to copy the contents of this
     * Object into the clone.
     * @return		a copy of this Object.
     * @exception	OutOfMemoryError If there is not enough memory.
     * @see		Object#copy
     */
    protected native Object clone();

    /**
     * Returns a String that represents the value of this Object.  It is recommended
     * that all subclasses override this method.
     */
    public native String toString();

    /**
     * Notifies a single waiting thread on a change in condition of another thread. 
     * The thread effecting the change notifies the waiting thread
     * using notify(). Threads that want to wait for a condition to 
     * change before proceeding can call wait(). <p>
     * <em>The method notify() can only be called from within a synchronized method.</em>
     *
     * @exception	InternalError If the current thread is not the owner of the
     *			Object's monitor.
     * @see		Object#wait
     * @see		Object#notifyAll
     */
    public final native void notify();

    /**
     * Notifies all of the threads waiting for a condition to change.
     * Threads that are waiting are generally waiting for another thread to 
     * change some condition. Thus, the thread effecting a change that more 
     * than one thread is waiting for notifies all the waiting threads using
     * the method notifyAll(). Threads that want to wait for a condition to 
     * change before proceeding can call wait(). <p>
     * <em>The method notifyAll() can only be called from within a synchronized method.</em>
     *
     * @exception	InternalError If the current thread is not the owner of the
     *			Object's monitor.
     * @see		Object#wait
     * @see		Object#notify
      */
    public final native void notifyAll();

    /**
     * Causes a thread to wait until it is notified or the specified timeout
     * expires. <p>
     * <em>The method wait() can only be called from within a synchronized method.</em>
     *
     * @param timeout	the maximum time to wait in milliseconds
     * @exception	InternalError If the current thread is not the owner of the
     *			Object's monitor.
     */
    public final native void wait(long timeout) throws InterruptedException;

    /**
     * More accurate wait.
     * <em>The method wait() can only be called from within a synchronized method.</em>
     *
     * @param timeout	the maximum time to wait in milliseconds
     * @param nano      additional time, in nanoseconds range 0-999999
     * @exception	InternalError If the current thread is not the owner of the
     *			Object's monitor.
     */
    public final void wait(long timeout, int nanos) throws InterruptedException {
	if (nanos >= 500000 || (nanos != 0 && timeout==0))
	    timeout++;
	wait(timeout);
    }

    /**
     * Causes a thread to wait forever until it is notified. <p>
     * <em>The method wait() can only be called from within a synchronized method</em>
     *
     * @exception	InternalError If the current thread is not the owner of the
     *			Object's monitor.
     */
    public final void wait() throws InterruptedException {
	wait(0);
    }
}

