#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <unistd.h>
#include "config.h"

int sock, sock2;
pid_t cpid;

#ifndef TRUE
#define TRUE 1
#define FALSE (!TRUE)
#endif

char bind_success;

int wait_for_request(char *argv[])
{
	int i;
	struct sockaddr_in addr;

	bind_success=FALSE;
	while(!bind_success) {
		if ((sock=socket(AF_INET, SOCK_STREAM, 0))<0) {
			fprintf(stderr, "%s: Error: unable to bind socket.\n", argv[0]);
			exit(16);
		}
		addr.sin_family=AF_INET;
		addr.sin_port=htons(PORT);
		addr.sin_addr.s_addr=htonl(0L);
		i=sizeof addr;
		if(bind(sock, (struct sockaddr *)(&addr), i)<0) {
#ifdef CONF_DEBUG
			fprintf(stderr, "%s: DEBUG: unable to bind socket -- address already in use. Retrying in 1 msec.\n", argv[0]);
#endif
			usleep(1000);
			shutdown(sock, 2);
			shutdown(sock2, 2);
			close(sock);
			close(sock2);
		}
		else {
			bind_success=TRUE;
		}
	}
	listen(sock, 2);
	if((sock2=accept(sock, (struct sockaddr *)(&addr), &i))<0) {
		fprintf(stderr, "%s: Error: accept failed.\n", argv[0]);
		exit(64);
	}
	shutdown(sock, 2);
	shutdown(sock2, 2);
	close(sock);
	close(sock2);
	return(0);
}

int main(int argc, char *argv[])
{
#ifndef CONF_DEBUG
	switch(fork()) {
		case 0: /* I am the child */
#else
	fprintf(stderr, "%s: DEBUG: Debugging information enabled, will not fork.\n", argv[0]);
#endif
			while(TRUE) {
						wait_for_request(argv);
#ifdef CONF_DEBUG
						fprintf(stderr, "%s: DEBUG: sping request received.\n", argv[0]);
#endif
			}
#ifndef CONF_DEBUG
		case -1: /* fork failed */
			fprintf(stderr, "%s: Error: can't fork.\n", argv[0]);
			exit(1);
		default: /* I am the parent */
			return(0);
	}
#endif
}

